/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.hotkeys;

import com.tulskiy.keymaster.common.Provider;
import java.util.logging.Logger;
import javax.swing.KeyStroke;

public class GlobalHotkeySetter {
    private static final Logger LOGGER = Logger.getLogger(GlobalHotkeySetter.class.getName());
    private final GlobalHotkeyListener listener;
    private String error = "Global hotkey error";
    private Provider hotkeys;
    private boolean anyRegistered;

    public GlobalHotkeySetter(GlobalHotkeyListener listener) {
        this.listener = listener;
        try {
            this.hotkeys = Provider.getCurrentProvider(true);
            if (this.hotkeys == null) {
                this.error = "Global hotkeys: Platform not supported";
            }
        }
        catch (Throwable ex) {
            LOGGER.warning("Global hotkey error: " + ex);
            this.error = "Global hotkey error: " + ex;
        }
    }

    public String getError() {
        return this.error;
    }

    public boolean isActive() {
        return this.hotkeys != null && this.hotkeys.isRunning();
    }

    public void registerHotkey(Object hotkeyId, KeyStroke keyStroke) {
        if (!this.isActive()) {
            return;
        }
        try {
            LOGGER.info("[Global Hotkeys] Trying to register hotkey: " + hotkeyId);
            this.hotkeys.register(keyStroke, h -> this.listener.onHotkey(hotkeyId));
            this.anyRegistered = true;
        }
        catch (Throwable ex) {
            LOGGER.info("[Global Hotkeys] Error registering hotkey: " + ex);
        }
    }

    public void unregisterAllHotkeys() {
        if (!this.isActive() || !this.anyRegistered) {
            return;
        }
        try {
            this.hotkeys.reset();
            this.anyRegistered = false;
        }
        catch (Throwable ex) {
            LOGGER.warning("[Global Hotkeys] Error resetting: " + ex);
        }
    }

    public void cleanUp() {
        if (!this.isActive()) {
            return;
        }
        try {
            this.hotkeys.close();
        }
        catch (Throwable ex) {
            LOGGER.warning("[Global Hotkeys] Error closing: " + ex);
        }
    }

    public static interface GlobalHotkeyListener {
        public void onHotkey(Object var1);
    }
}

