/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.hotkeys;

import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;

public class Hotkey {
    public final String actionId;
    public final String custom;
    public final KeyStroke keyStroke;
    public final Type type;
    public final int delay;
    private long lastActionExecuted;

    public Hotkey(String actionId, KeyStroke hotkey, Type type, String custom, int delay) {
        this.actionId = actionId;
        this.keyStroke = hotkey;
        this.type = type;
        this.custom = custom;
        this.delay = delay;
    }

    public String getHotkeyText() {
        return Hotkey.keyStrokeToText(this.keyStroke);
    }

    public boolean shouldExecuteAction() {
        if (this.delay <= 0) {
            return true;
        }
        long timePassed = System.currentTimeMillis() - this.lastActionExecuted;
        if (timePassed > (long)(this.delay * 100)) {
            this.lastActionExecuted = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public boolean hasValidCode() {
        return this.keyStroke.getKeyCode() != 0;
    }

    public static String keyStrokeToText(KeyStroke keyStroke) {
        String mod = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
        String key = KeyEvent.getKeyText(keyStroke.getKeyCode());
        if (mod.isEmpty() || mod.equals(key)) {
            return key;
        }
        return mod + "+" + key;
    }

    public String toString() {
        if (this.custom != null && !this.custom.isEmpty()) {
            return String.format("%s(%s)[%s][%s/%d]", new Object[]{this.actionId, this.custom, Hotkey.keyStrokeToText(this.keyStroke), this.type, this.delay});
        }
        return String.format("%s[%s][%s/%d]", new Object[]{this.actionId, Hotkey.keyStrokeToText(this.keyStroke), this.type, this.delay});
    }

    public static enum Type {
        REGULAR(0, "Regular"),
        APPLICATION(1, "App"),
        GLOBAL(2, "Global"),
        UNDEFINED(-1, "undefined");

        public int id;
        public String name;

        private Type(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public static Type getTypeFromId(int typeId) {
            for (Type type : Type.values()) {
                if (type.id != typeId) continue;
                return type;
            }
            return UNDEFINED;
        }
    }
}

