/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.hotkeys;

import chatty.Logging;
import chatty.gui.MainGui;
import chatty.util.StringUtil;
import chatty.util.hotkeys.GlobalHotkeySetter;
import chatty.util.hotkeys.Hotkey;
import chatty.util.hotkeys.HotkeyAction;
import chatty.util.settings.Settings;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;

public class HotkeyManager {
    private static final Logger LOGGER = Logger.getLogger(HotkeyManager.class.getName());
    private static final String SETTING_NAME = "hotkeys";
    private static final int INPUT_MAP_KEY = 2;
    private static final String PREFIX = "chatty.util.hotkeys.";
    private Settings settings;
    private final MainGui main;
    private final List<Hotkey> hotkeys = new ArrayList<Hotkey>();
    private final Map<String, HotkeyAction> actions = new LinkedHashMap<String, HotkeyAction>();
    private final Map<JRootPane, Object> popouts = new WeakHashMap<JRootPane, Object>();
    private boolean globalHotkeysRegister = true;
    private boolean globalHotkeysEnabled = false;
    private boolean enabled = true;
    private GlobalHotkeySetter globalHotkeys;
    private boolean attemptedToInitGlobalHotkeys;
    private String globalHotkeyErrorWarning;

    public HotkeyManager(MainGui main) {
        this.main = main;
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        kfm.addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                return HotkeyManager.this.applicationKeyTriggered(e);
            }
        });
    }

    private void initGlobalHotkeys() {
        if (!this.attemptedToInitGlobalHotkeys) {
            this.attemptedToInitGlobalHotkeys = true;
            try {
                this.globalHotkeys = new GlobalHotkeySetter(new GlobalHotkeySetter.GlobalHotkeyListener(){

                    @Override
                    public void onHotkey(Object hotkeyId) {
                        HotkeyManager.this.onGlobalHotkey(hotkeyId);
                    }
                });
                if (!this.globalHotkeys.isActive()) {
                    this.globalHotkeyErrorWarning = this.globalHotkeys.getError();
                    this.globalHotkeys = null;
                }
            }
            catch (NoClassDefFoundError ex) {
                LOGGER.warning("Failed to initialize hotkey setter [" + ex + "]");
                this.globalHotkeyErrorWarning = "Failed to initialize global hotkeys (library not found).";
                this.globalHotkeys = null;
            }
        }
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public void registerAction(String id, String label, String description, Action action) {
        HotkeyAction hotkeyAction = new HotkeyAction(id, label, description, action);
        this.actions.put(id, hotkeyAction);
    }

    public void registerAction(String id, String label, Action action) {
        this.registerAction(id, label, null, action);
    }

    public void registerPopout(Object popout) {
        JRootPane pane = null;
        if (popout instanceof JWindow) {
            pane = ((JWindow)popout).getRootPane();
        } else if (popout instanceof JFrame) {
            pane = ((JFrame)popout).getRootPane();
        } else if (popout instanceof JDialog) {
            pane = ((JDialog)popout).getRootPane();
        }
        if (pane != null) {
            this.popouts.put(pane, null);
            this.addHotkeys(pane);
        }
    }

    public Map<String, String> getActionsMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (HotkeyAction action : this.actions.values()) {
            map.put(action.id, action.label);
        }
        return map;
    }

    public Map<String, String> getDescriptionsMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (HotkeyAction action : this.actions.values()) {
            if (StringUtil.isNullOrEmpty(action.description)) continue;
            map.put(action.id, action.description);
        }
        return map;
    }

    public synchronized void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled || this.globalHotkeysEnabled) {
            this.setGlobalHotkeysRegistered(enabled);
        }
    }

    public synchronized void setGlobalHotkeysEnabled(boolean enabled) {
        this.globalHotkeysEnabled = enabled;
        this.setGlobalHotkeysRegistered(enabled);
    }

    private void setGlobalHotkeysRegistered(boolean register) {
        if (register == this.globalHotkeysRegister) {
            return;
        }
        this.globalHotkeysRegister = register;
        if (register) {
            this.removeGlobalHotkeys();
            this.addGlobalHotkeys();
        } else {
            this.removeGlobalHotkeys();
        }
    }

    public synchronized void setData(Collection<Hotkey> hotkeysData) {
        if (!this.hotkeys.equals(hotkeysData)) {
            this.hotkeys.clear();
            this.hotkeys.addAll(hotkeysData);
            this.updateHotkeys();
            this.saveToSettings();
        }
    }

    public synchronized List<Hotkey> getData() {
        return new ArrayList<Hotkey>(this.hotkeys);
    }

    public boolean globalHotkeysAvailable() {
        return true;
    }

    public void cleanUp() {
        if (this.globalHotkeys != null) {
            this.globalHotkeys.cleanUp();
        }
    }

    public void refreshHotkeys(JRootPane pane) {
        this.removeHotkeys(pane);
        this.addHotkeys(pane);
    }

    private boolean doesHotkeyHaveAction(Hotkey hotkey) {
        return this.actions.get(hotkey.actionId) != null;
    }

    private boolean isValidHotkey(Hotkey hotkey) {
        return this.doesHotkeyHaveAction(hotkey) && hotkey.hasValidCode();
    }

    private void updateHotkeys() {
        this.removeAllHotkeys();
        this.addHotkeys(null);
        this.addGlobalHotkeys();
        this.updateActions();
    }

    private void addHotkeys(JRootPane pane) {
        for (Hotkey hotkey : this.hotkeys) {
            if (!this.isValidHotkey(hotkey) || hotkey.type != Hotkey.Type.REGULAR) continue;
            if (pane == null) {
                this.addHotkey(hotkey, this.main.getRootPane());
                for (JRootPane popoutPane : this.popouts.keySet()) {
                    this.addHotkey(hotkey, popoutPane);
                }
                continue;
            }
            this.addHotkey(hotkey, pane);
        }
    }

    private void addHotkey(Hotkey hotkey, JRootPane pane) {
        String id = String.valueOf(hotkey.hashCode());
        pane.getInputMap(2).put(hotkey.keyStroke, PREFIX + id);
        pane.getActionMap().put(PREFIX + id, this.createAction(hotkey));
    }

    private void addGlobalHotkeys() {
        if (!this.globalHotkeysRegister) {
            return;
        }
        if (this.hasGlobalHotkey()) {
            this.initGlobalHotkeys();
        }
        if (this.globalHotkeys == null) {
            return;
        }
        for (Hotkey hotkey : this.hotkeys) {
            if (!this.isValidHotkey(hotkey) || hotkey.type != Hotkey.Type.GLOBAL) continue;
            this.globalHotkeys.registerHotkey(hotkey, hotkey.keyStroke);
        }
    }

    private void removeAllHotkeys() {
        this.removeHotkeys(this.main.getRootPane());
        for (JRootPane popoutPane : this.popouts.keySet()) {
            this.removeHotkeys(popoutPane);
        }
        this.removeGlobalHotkeys();
        this.removeHotkeysFromActions();
    }

    private void removeGlobalHotkeys() {
        if (this.globalHotkeys != null) {
            this.globalHotkeys.unregisterAllHotkeys();
        }
    }

    private void removeHotkeys(JRootPane pane) {
        HashSet<KeyStroke> toBeRemoved = new HashSet<KeyStroke>();
        InputMap input = pane.getInputMap(2);
        ActionMap action = pane.getActionMap();
        if (input.keys() == null) {
            return;
        }
        for (KeyStroke keyStroke : input.keys()) {
            Object key = input.get(keyStroke);
            if (!(key instanceof String) || !((String)key).startsWith(PREFIX)) continue;
            toBeRemoved.add(keyStroke);
            action.remove(key);
        }
        for (KeyStroke keyStroke : toBeRemoved) {
            input.remove(keyStroke);
        }
    }

    private void removeHotkeysFromActions() {
        for (HotkeyAction action : this.actions.values()) {
            action.action.putValue("AcceleratorKey", null);
        }
    }

    private synchronized void saveToSettings() {
        if (this.settings != null) {
            ArrayList<List<Object>> dataToSave = new ArrayList<List<Object>>();
            for (Hotkey hotkey : this.hotkeys) {
                dataToSave.add(this.hotkeyToList(hotkey));
            }
            this.settings.putList(SETTING_NAME, dataToSave);
        }
    }

    public synchronized void loadFromSettings(Settings settings) {
        this.settings = settings;
        List loadFrom = settings.getList(SETTING_NAME);
        this.hotkeys.clear();
        for (List l : loadFrom) {
            Hotkey entry = this.listToHotkey(l);
            if (entry == null) continue;
            this.hotkeys.add(entry);
        }
        this.updateHotkeys();
        this.checkGlobalHotkeyWarning();
    }

    private List<Object> hotkeyToList(Hotkey hotkey) {
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(hotkey.actionId);
        l.add(hotkey.keyStroke.toString());
        l.add(hotkey.type.id);
        l.add(hotkey.custom);
        l.add(hotkey.delay);
        return l;
    }

    private Hotkey listToHotkey(List list) {
        try {
            String actionId = (String)list.get(0);
            KeyStroke keyStroke = KeyStroke.getKeyStroke((String)list.get(1));
            if (keyStroke == null) {
                LOGGER.warning("Error loading hotkey, invalid: " + list);
                return null;
            }
            Hotkey.Type type = Hotkey.Type.REGULAR;
            String custom = "";
            int delay = 0;
            if (list.size() > 2) {
                type = Hotkey.Type.getTypeFromId(((Number)list.get(2)).intValue());
            }
            if (list.size() > 3) {
                custom = (String)list.get(3);
            }
            if (list.size() > 4) {
                delay = ((Number)list.get(4)).intValue();
            }
            return new Hotkey(actionId, keyStroke, type, custom, delay);
        }
        catch (ClassCastException | IndexOutOfBoundsException | NullPointerException ex) {
            LOGGER.warning("Error loading hotkey: " + list + " [" + ex + "]");
            return null;
        }
    }

    private void checkGlobalHotkeyWarning() {
        if (this.globalHotkeyErrorWarning == null) {
            return;
        }
        if (this.hasGlobalHotkey()) {
            LOGGER.log(Logging.USERINFO, this.globalHotkeyErrorWarning + " [You are getting this message because you have a global hotkey configured. If you don't use it you can ignore this warning.]");
            this.globalHotkeyErrorWarning = null;
        }
    }

    private boolean hasGlobalHotkey() {
        for (Hotkey hotkey : this.hotkeys) {
            if (!this.isValidHotkey(hotkey) || hotkey.type != Hotkey.Type.GLOBAL) continue;
            return true;
        }
        return false;
    }

    private Action createAction(final Hotkey hotkey) {
        final HotkeyAction hotkeyAction = this.actions.get(hotkey.actionId);
        if (hotkeyAction == null) {
            return null;
        }
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.enabled && hotkey.shouldExecuteAction()) {
                    hotkeyAction.action.actionPerformed(new ActionEvent(hotkeyAction, 0, hotkey.custom));
                }
            }
        };
    }

    private void updateActions() {
        for (Hotkey hotkey : this.hotkeys) {
            this.updateAction(hotkey);
        }
    }

    private void updateAction(Hotkey hotkey) {
        HotkeyAction hotkeyAction = this.actions.get(hotkey.actionId);
        if (hotkeyAction == null) {
            return;
        }
        if (hotkey.hasValidCode()) {
            hotkeyAction.action.putValue("AcceleratorKey", hotkey.keyStroke);
        }
    }

    private void onGlobalHotkey(Object hotkeyId) {
        Hotkey hotkey = (Hotkey)hotkeyId;
        HotkeyAction action = this.actions.get(hotkey.actionId);
        if (this.enabled && action != null && hotkey.shouldExecuteAction()) {
            action.action.actionPerformed(new ActionEvent(action, 0, hotkey.custom));
        }
    }

    private boolean applicationKeyTriggered(KeyEvent e) {
        if (!this.enabled) {
            return false;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
        for (Hotkey hotkey : this.hotkeys) {
            HotkeyAction action;
            if (hotkey.type != Hotkey.Type.APPLICATION || !hotkey.keyStroke.equals(keyStroke) || !hotkey.hasValidCode() || (action = this.actions.get(hotkey.actionId)) == null || !hotkey.shouldExecuteAction()) continue;
            action.action.actionPerformed(new ActionEvent(action, 0, hotkey.custom));
            return true;
        }
        return false;
    }
}

