/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.irc;

import chatty.util.MiscUtil;
import java.util.Arrays;
import java.util.function.BiConsumer;

public class IrcBadges {
    private final String[] badges;
    private static final IrcBadges EMPTY = new IrcBadges(new String[0]);

    public IrcBadges(String[] badges) {
        this.badges = badges;
    }

    public String get(String id) {
        for (int i = 0; i < this.badges.length; i += 2) {
            if (!this.badges[i].equals(id)) continue;
            return this.badges[i + 1];
        }
        return null;
    }

    public boolean hasId(String id) {
        return this.get(id) != null;
    }

    public boolean hasIdVersion(String id, String version) {
        String actualVersion = this.get(id);
        return actualVersion != null && actualVersion.equals(version);
    }

    public String getVersion(int i) {
        return this.badges[i * 2 + 1];
    }

    public String getId(int i) {
        return this.badges[i * 2];
    }

    public int size() {
        return this.badges.length / 2;
    }

    public boolean isEmpty() {
        return this.badges.length == 0;
    }

    public void forEach(BiConsumer<String, String> consumer) {
        for (int i = 0; i < this.badges.length; i += 2) {
            consumer.accept(this.badges[i], this.badges[i + 1]);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IrcBadges other = (IrcBadges)obj;
        return Arrays.deepEquals(this.badges, other.badges);
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + Arrays.deepHashCode(this.badges);
        return hash;
    }

    public static IrcBadges parse(String data) {
        if (data == null || data.isEmpty()) {
            return EMPTY;
        }
        String[] badges = data.split(",");
        String[] result = new String[badges.length * 2];
        int counter = 0;
        for (String badge : badges) {
            String[] split = badge.split("/", 2);
            if (split.length != 2) continue;
            String id = MiscUtil.intern(split[0]);
            String version = MiscUtil.intern(split[1]);
            result[counter++] = id;
            result[counter++] = version;
        }
        if (counter < result.length) {
            String[] newResult = new String[counter];
            System.arraycopy(result, 0, newResult, 0, newResult.length);
            return new IrcBadges(newResult);
        }
        return new IrcBadges(result);
    }
}

