/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.irc;

import chatty.Helper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class IrcMsgTags {
    private static final Map<String, String> EMPTY_TAGS = new HashMap<String, String>();
    public static final IrcMsgTags EMPTY = new IrcMsgTags(null);
    private final Map<String, String> tags;
    private static final Pattern KEY_PATTERN = Pattern.compile("[a-z0-9-]+", 2);

    protected IrcMsgTags(Map<String, String> tags) {
        this.tags = tags == null ? EMPTY_TAGS : tags;
    }

    public boolean containsKey(String key) {
        return this.tags.containsKey(key);
    }

    public Set<String> keys() {
        return new HashSet<String>(this.tags.keySet());
    }

    public void fill(Map<String, String> map) {
        map.putAll(this.tags);
    }

    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    public boolean isTrue(String key) {
        return "1".equals(this.tags.get(key));
    }

    public boolean isValue(String key, String value) {
        return value.equals(this.tags.get(key));
    }

    public boolean isValueOf(String key, String ... values) {
        for (String value : values) {
            if (!value.equals(this.tags.get(key))) continue;
            return true;
        }
        return false;
    }

    public boolean hasValue(String key) {
        String value = this.tags.get(key);
        return value != null && !value.isEmpty();
    }

    public String get(String key) {
        return this.get(key, null);
    }

    public String get(String key, String defaultValue) {
        if (this.tags.containsKey(key)) {
            return this.tags.get(key);
        }
        return defaultValue;
    }

    public int getInteger(String key, int defaultValue) {
        if (this.tags.get(key) != null) {
            try {
                return Integer.parseInt(this.tags.get(key));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public boolean hasInteger(String key) {
        try {
            Integer.parseInt(this.tags.get(key));
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public long getLong(String key, long defaultValue) {
        if (this.tags.get(key) != null) {
            try {
                return Long.parseLong(this.tags.get(key));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public String toTagsString() {
        StringBuilder b = new StringBuilder();
        Iterator<String> it = this.tags.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            String value = this.tags.get(key);
            if (!IrcMsgTags.isValidKey(key)) continue;
            b.append(key);
            if (IrcMsgTags.isValidValue(value)) {
                b.append("=").append(IrcMsgTags.escapeValue(value));
            }
            if (!it.hasNext()) continue;
            b.append(";");
        }
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IrcMsgTags other = (IrcMsgTags)obj;
        return Objects.equals(this.tags, other.tags);
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + Objects.hashCode(this.tags);
        return hash;
    }

    private static boolean isValidKey(String key) {
        return KEY_PATTERN.matcher(key).matches();
    }

    private static boolean isValidValue(String value) {
        return value != null;
    }

    private static String escapeValue(String value) {
        return Helper.tagsvalue_encode(value);
    }

    public String toString() {
        return this.tags.toString();
    }

    public static Map<String, String> createTags(String ... args) {
        HashMap<String, String> tags = new HashMap<String, String>();
        Iterator<String> it = Arrays.asList(args).iterator();
        while (it.hasNext()) {
            String key = it.next();
            if (it.hasNext()) {
                tags.put(key, it.next());
                continue;
            }
            tags.put(key, null);
        }
        return tags;
    }

    public static Map<String, String> parseTags(String data) {
        if (data == null) {
            return null;
        }
        String[] tags = data.split(";");
        if (tags.length > 0) {
            HashMap<String, String> result = new HashMap<String, String>();
            for (String tag : tags) {
                String[] keyValue = tag.split("=", 2);
                if (keyValue.length == 2) {
                    result.put(keyValue[0], Helper.tagsvalue_decode(keyValue[1]));
                    continue;
                }
                if (keyValue[0].isEmpty()) continue;
                result.put(keyValue[0], null);
            }
            return result;
        }
        return null;
    }
}

