/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.irc;

import chatty.util.StringUtil;
import chatty.util.irc.IrcMsgTags;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MsgTags
extends IrcMsgTags {
    public static final MsgTags EMPTY = new MsgTags(null, null);
    private Map<String, Object> objects;
    public static final String IS_HIGHLIGHTED = "chatty-highlighted";
    public static final String SHARED_MESSAGE_SOURCE_CHANNEL = "chatty-source-channel";

    public MsgTags(Map<String, String> tags, Map<String, Object> objects) {
        super(tags);
        this.objects = objects;
    }

    public String getId() {
        return this.get("id");
    }

    public boolean hasId() {
        return this.hasValue("id");
    }

    public int getBits() {
        return this.getInteger("bits", 0);
    }

    public String getRawEmotes() {
        return this.get("emotes");
    }

    public boolean isHighlightedMessage() {
        return this.isValue("msg-id", "highlighted-message");
    }

    public boolean isCustomReward() {
        return this.hasValue("custom-reward-id");
    }

    public String getCustomRewardId() {
        return this.get("custom-reward-id");
    }

    public boolean isFromEventSub() {
        return this.isValue("chatty-source", "eventsub");
    }

    public boolean isHistoricMsg() {
        return this.hasValue("historic-timestamp");
    }

    public long getHistoricTimeStamp() {
        if (this.isHistoricMsg()) {
            return Long.parseLong(this.get("historic-timestamp"));
        }
        return -1L;
    }

    public boolean isRestrictedMessage() {
        return this.isValue("chatty-is-restricted", "1");
    }

    public boolean hasReplyUserMsg() {
        return this.hasValue("reply-parent-msg-body") && this.hasValue("reply-parent-display-name");
    }

    public String getReplyUserMsg() {
        if (this.hasReplyUserMsg()) {
            return String.format("<%s> %s", this.get("reply-parent-display-name"), this.get("reply-parent-msg-body"));
        }
        return null;
    }

    public boolean isReply() {
        return this.hasValue("reply-parent-msg-id");
    }

    public String getReplyParentMsgId() {
        return this.get("reply-parent-msg-id");
    }

    public String getReplyThreadParentMsgId() {
        return this.get("reply-thread-parent-msg-id");
    }

    public String getHypeChatAmountText() {
        int amount = this.getInteger("pinned-chat-paid-amount", -1);
        String currency = this.get("pinned-chat-paid-currency");
        int exponent = this.getInteger("pinned-chat-paid-exponent", -1);
        if (amount > 0 && !StringUtil.isNullOrEmpty(currency) && exponent != -1) {
            return String.format("%s %s", currency, new BigDecimal(amount).scaleByPowerOfTen(-exponent));
        }
        return null;
    }

    public String getHypeChatInfo() {
        return String.format("Level %s Hype Chat for %s", this.get("pinned-chat-paid-level"), this.getHypeChatAmountText());
    }

    public String getPowerUpInfo() {
        if (this.hasValue("msg-id")) {
            switch (this.get("msg-id")) {
                case "gigantified-emote-message": {
                    return "Gigantified Emote";
                }
                case "animated-message": {
                    return String.format("Styled Message (%s)", StringUtil.shortenTo(this.get("animation-id"), 20));
                }
            }
        }
        return null;
    }

    public boolean hasGigantifiedEmote() {
        return this.isValue("msg-id", "gigantified-emote-message");
    }

    public boolean isChattyHighlighted() {
        return this.hasValue(IS_HIGHLIGHTED);
    }

    public boolean isSharedMessage() {
        return this.hasValue("source-room-id") && !this.get("source-room-id").equals(this.get("room-id"));
    }

    public boolean isSharedChatActive() {
        return this.hasValue("source-room-id");
    }

    public String getSourceChannel() {
        return this.get(SHARED_MESSAGE_SOURCE_CHANNEL);
    }

    public String getSourceId() {
        return this.get("source-id");
    }

    public static MsgTags parse(String tags) {
        Map<String, String> parsedTags = MsgTags.parseTags(tags);
        if (parsedTags == null) {
            return EMPTY;
        }
        return new MsgTags(parsedTags, null);
    }

    public static MsgTags create(String ... args) {
        return new MsgTags(MsgTags.createTags(args), null);
    }

    public void fillObjects(Map<String, Object> map) {
        if (this.objects != null) {
            map.putAll(this.objects);
        }
    }

    private void addObject(String key, Object value) {
        if (this.objects == null) {
            this.objects = new HashMap<String, Object>();
        }
        this.objects.put(key, value);
    }

    public static MsgTags merge(MsgTags a, MsgTags b) {
        HashMap<String, String> result = new HashMap<String, String>();
        b.fill(result);
        a.fill(result);
        HashMap<String, Object> objectsResult = new HashMap<String, Object>();
        b.fillObjects(objectsResult);
        a.fillObjects(objectsResult);
        return new MsgTags(result, objectsResult);
    }

    public static MsgTags addTag(MsgTags a, String key, String value) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (a != null) {
            a.fill(result);
        }
        result.put(key, value);
        HashMap<String, Object> objectsResult = new HashMap<String, Object>();
        if (a != null) {
            a.fillObjects(objectsResult);
        }
        return new MsgTags(result, objectsResult);
    }

    public List<Link> getLinks() {
        if (this.objects != null && this.objects.containsKey("links")) {
            return (List)this.objects.get("links");
        }
        return new ArrayList<Link>();
    }

    public static MsgTags createLinks(Link ... input) {
        MsgTags tags = MsgTags.create("");
        tags.addObject("links", MsgTags.createLinksObject(input));
        return tags;
    }

    public static Object createLinksObject(Link ... links) {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link link : links) {
            result.add(link);
        }
        return result;
    }

    public static class Link {
        public final Type type;
        public final String target;
        public final String label;
        public final int startIndex;
        public final int endIndex;

        public Link(Type type, String target, int startIndex, int endIndex) {
            this.type = type;
            this.target = target;
            this.label = "";
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        public Link(Type type, String target, String label) {
            this.type = type;
            this.target = target;
            this.label = label;
            this.startIndex = -1;
            this.endIndex = -1;
        }

        public String toString() {
            return String.format("[%s.%s %s](%d-%d)", new Object[]{this.type, this.target, this.label, this.startIndex, this.endIndex});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Link other = (Link)obj;
            if (this.startIndex != other.startIndex) {
                return false;
            }
            if (this.endIndex != other.endIndex) {
                return false;
            }
            if (!Objects.equals(this.target, other.target)) {
                return false;
            }
            if (!Objects.equals(this.label, other.label)) {
                return false;
            }
            return this.type == other.type;
        }

        public int hashCode() {
            int hash = 3;
            hash = 79 * hash + Objects.hashCode((Object)this.type);
            hash = 79 * hash + Objects.hashCode(this.target);
            hash = 79 * hash + Objects.hashCode(this.label);
            hash = 79 * hash + this.startIndex;
            hash = 79 * hash + this.endIndex;
            return hash;
        }

        public static enum Type {
            JOIN,
            URL;

        }
    }
}

