/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.irc;

import chatty.util.irc.MsgParameters;
import chatty.util.irc.MsgTags;
import java.util.logging.Logger;

public class ParsedMsg {
    private static final Logger LOGGER = Logger.getLogger(ParsedMsg.class.getName());
    private final MsgTags tags;
    private final String prefix;
    private final String nick;
    private final String command;
    private final MsgParameters parameters;

    private ParsedMsg(MsgTags tags, String prefix, String nick, String command, MsgParameters parameters) {
        this.tags = tags;
        this.prefix = prefix;
        this.nick = nick;
        this.command = command;
        this.parameters = parameters;
    }

    public MsgTags getTags() {
        return this.tags;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getNick() {
        return this.nick;
    }

    public String getCommand() {
        return this.command;
    }

    public MsgParameters getParameters() {
        return this.parameters;
    }

    public static ParsedMsg parse(String input) {
        int start;
        if (input == null) {
            return null;
        }
        MsgTags tags = MsgTags.EMPTY;
        if (input.startsWith("@")) {
            int endOfTags = input.indexOf(" ");
            if (endOfTags == -1) {
                LOGGER.warning("Parsing error: Couldn't find whitespace after tags: " + input);
                return null;
            }
            tags = MsgTags.parse(input.substring(1, endOfTags));
            input = input.substring(endOfTags + 1);
        }
        String prefix = "";
        String command = null;
        MsgParameters parameters = new MsgParameters();
        int endOfPrefix = -1;
        if (input.startsWith(":")) {
            endOfPrefix = input.indexOf(" ");
            if (endOfPrefix == -1) {
                LOGGER.warning("Parsing error: Couldn't find whitespace after prefix: " + input);
                return null;
            }
            prefix = input.substring(1, endOfPrefix);
        }
        int next = endOfPrefix;
        while ((start = next + 1) != input.length()) {
            int end;
            next = input.indexOf(" ", start);
            if (next == -1 || input.charAt(start) == ':') {
                if (input.charAt(start) == ':') {
                    ++start;
                }
                end = input.length();
                next = -1;
            } else {
                end = next;
            }
            String part = input.substring(start, end);
            if (!part.isEmpty()) {
                if (command == null) {
                    command = part;
                } else {
                    parameters.add(part);
                }
            }
            if (next != -1) continue;
        }
        if (command == null) {
            return null;
        }
        return new ParsedMsg(tags, prefix, ParsedMsg.getNickFromPrefix(prefix), command, parameters);
    }

    private static String getNickFromPrefix(String sender) {
        int endOfNick = sender.indexOf("!");
        if (endOfNick == -1) {
            return sender;
        }
        return sender.substring(0, endOfNick);
    }

    public String toString() {
        return this.tags + "/" + this.prefix + "/" + this.nick + "/" + this.command + "/" + this.parameters;
    }
}

