/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.irc;

import chatty.Helper;
import chatty.User;
import chatty.util.StringUtil;
import chatty.util.irc.IrcBadges;
import chatty.util.irc.MsgTags;

public class UserTagsUtil {
    public static boolean updateUserFromTags(User user, MsgTags tags) {
        boolean subscriber;
        boolean turbo;
        String color;
        if (tags.isEmpty()) {
            return false;
        }
        boolean changed = false;
        IrcBadges badges = IrcBadges.parse(tags.get("badges"));
        if (user.setTwitchBadges(badges)) {
            changed = true;
        }
        UserTagsUtil.updateUserBadgeInfo(user, tags, false);
        if (user.setDisplayNick(StringUtil.trim(tags.get("display-name")))) {
            changed = true;
        }
        if ((color = tags.get("color")) != null && !color.isEmpty()) {
            user.setColor(color);
        }
        boolean bl = turbo = tags.isTrue("turbo") || badges.hasId("turbo") || badges.hasId("premium");
        if (user.setTurbo(turbo)) {
            changed = true;
        }
        boolean bl2 = subscriber = badges.hasId("subscriber") || badges.hasId("founder");
        if (user.setSubscriber(subscriber)) {
            changed = true;
        }
        if (user.setVip(badges.hasId("vip"))) {
            changed = true;
        }
        if (user.setModerator(badges.hasId("moderator") || badges.hasId("lead_moderator"))) {
            changed = true;
        }
        if (user.setAdmin(badges.hasId("admin"))) {
            changed = true;
        }
        if (user.setStaff(badges.hasId("staff"))) {
            changed = true;
        }
        user.setId(tags.get("user-id"));
        return changed;
    }

    public static void updateUserBadgeInfo(User user, MsgTags tags, boolean source) {
        IrcBadges badgeInfo = IrcBadges.parse(tags.get(source ? "source-badge-info" : "badge-info"));
        String subMonths = badgeInfo.get("subscriber");
        if (subMonths == null) {
            subMonths = badgeInfo.get("founder");
        }
        if (subMonths != null) {
            user.setSubMonths(Helper.parseShort(subMonths, (short)0));
        }
    }
}

