/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.jws;

import chatty.util.DateTime;
import chatty.util.ElapsedTime;
import chatty.util.TimedCounter;
import chatty.util.jws.MessageHandler;
import java.net.URI;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.exceptions.WebsocketNotConnectedException;
import org.java_websocket.framing.Framedata;
import org.java_websocket.handshake.ServerHandshake;

public class JWSClient
implements MessageHandler {
    private static final Logger LOGGER = Logger.getLogger(JWSClient.class.getName());
    private final BlockingQueue<Received> received = new LinkedBlockingQueue<Received>();
    private final BlockingQueue<String> sending = new LinkedBlockingQueue<String>();
    private final WebSocketClient c;
    private final TimedCounter reconnectCounter = new TimedCounter(TimeUnit.MINUTES.toMillis(30L));
    private final ElapsedTime lastReceivedMessage = new ElapsedTime();
    private final ElapsedTime lastConnectionAttempt = new ElapsedTime();
    private final ElapsedTime lastActivity = new ElapsedTime();
    private final MessageHandler handler;
    private volatile String debugPrefix = "";
    private volatile boolean requestedClose = false;
    private volatile Thread readerThread;
    private volatile Thread writerThread;

    public JWSClient(URI server) {
        this(server, null);
    }

    public JWSClient(URI server, MessageHandler handler) {
        this.handler = handler != null ? handler : this;
        this.c = new WebSocketClient(server){

            @Override
            public void onOpen(ServerHandshake handshakedata) {
                LOGGER.info(String.format("%sConnection opened (%s/%s) [%s/%s]", JWSClient.this.debugPrefix, handshakedata.getHttpStatus(), handshakedata.getHttpStatusMessage(), this.getSocket().getRemoteSocketAddress(), this.getDraft()));
                JWSClient.this.received.add(new Received(Received.Type.OPEN, null, -1));
            }

            @Override
            public void onMessage(String message) {
                JWSClient.this.received.add(new Received(Received.Type.MESSAGE, message, -1));
                JWSClient.this.lastReceivedMessage.setSync();
                JWSClient.this.lastActivity.setSync();
            }

            @Override
            public void onWebsocketPing(WebSocket conn, Framedata f) {
                super.onWebsocketPing(conn, f);
                JWSClient.this.lastActivity.setSync();
            }

            @Override
            public void onWebsocketPong(WebSocket conn, Framedata f) {
                JWSClient.this.lastActivity.setSync();
            }

            @Override
            public void onClose(int code, String reason, boolean remote) {
                LOGGER.warning(String.format(JWSClient.this.debugPrefix + "Connection closed after %s (%s/%s)%s", DateTime.duration(JWSClient.this.lastConnectionAttempt.millisElapsedSync(), new DateTime.Formatting[0]), code, reason, remote ? " by remote host" : ""));
                JWSClient.this.received.add(new Received(Received.Type.CLOSE, reason, code));
                if (!JWSClient.this.requestedClose) {
                    this.reconnectTimer();
                }
            }

            @Override
            public void onError(Exception ex) {
                LOGGER.warning(JWSClient.this.debugPrefix + "Error " + ex);
            }

            private void reconnectTimer() {
                long interval = JWSClient.this.increaseAndGetReconnectWaitSeconds();
                LOGGER.info(JWSClient.this.debugPrefix + "Reconnecting in " + interval + "s..");
                Timer timer = new Timer(false);
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        LOGGER.info(JWSClient.this.debugPrefix + "Trying to reconnect to " + JWSClient.this.c.getURI());
                        JWSClient.this.lastConnectionAttempt.setSync();
                        this.reconnect();
                    }
                }, interval * 1000L);
            }
        };
    }

    public void init() {
        this.startConsumer();
        LOGGER.info(this.debugPrefix + "Trying to connect to " + this.c.getURI());
        this.lastConnectionAttempt.setSync();
        this.c.connect();
    }

    private long increaseAndGetReconnectWaitSeconds() {
        this.reconnectCounter.increase();
        int count = this.reconnectCounter.getCount();
        return Math.min(600L, (long)Math.pow(2.0, count)) + (long)ThreadLocalRandom.current().nextInt(count);
    }

    public void setDebugPrefix(String prefix) {
        this.debugPrefix = prefix;
    }

    private void startConsumer() {
        this.readerThread = new Thread(() -> {
            try {
                while (true) {
                    Received r;
                    if ((r = this.received.poll(10L, TimeUnit.SECONDS)) == null) {
                        continue;
                    }
                    switch (r.type) {
                        case MESSAGE: {
                            this.handler.handleReceived(r.message);
                            break;
                        }
                        case OPEN: {
                            this.handler.handleConnect(this);
                            break;
                        }
                        case CLOSE: {
                            this.handler.handleDisconnect(r.code);
                        }
                    }
                }
            }
            catch (InterruptedException ex) {
                return;
            }
        }, this.debugPrefix + "WS-Reader");
        this.readerThread.start();
        this.writerThread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        String message;
                        if ((message = this.sending.poll(10L, TimeUnit.SECONDS)) == null) {
                            continue;
                        }
                        this.c.send(message);
                        this.handler.handleSent(message);
                        this.lastActivity.setSync();
                    }
                }
                catch (WebsocketNotConnectedException message) {
                    continue;
                }
                break;
            }
            catch (InterruptedException ex) {
                return;
            }
        }, this.debugPrefix + "WS-Writer");
        this.writerThread.start();
    }

    public long getLastReceivedSecondsAgo() {
        return this.lastReceivedMessage.secondsElapsedSync();
    }

    public long getConnectionSeconds() {
        return this.lastConnectionAttempt.secondsElapsedSync();
    }

    public String getStatus() {
        if (!this.isOpen()) {
            return "Not connected.";
        }
        return String.format("Connected to %s (%s) since %s (last message received %s ago, last activity %s ago)", this.c.getURI(), this.c.getRemoteSocketAddress(), DateTime.duration(this.lastConnectionAttempt.millisElapsedSync(), new DateTime.Formatting[0]), DateTime.duration(this.lastReceivedMessage.millisElapsedSync(), new DateTime.Formatting[0]), DateTime.duration(this.lastActivity.millisElapsedSync(), new DateTime.Formatting[0]));
    }

    public void sendMessage(String message) {
        this.sending.add(message);
    }

    public boolean isOpen() {
        return this.c.isOpen();
    }

    public void disconnect() {
        LOGGER.info(this.debugPrefix + "Disconnecting");
        try {
            this.requestedClose = true;
            this.c.close();
            this.readerThread.interrupt();
            this.writerThread.interrupt();
        }
        catch (Exception ex) {
            LOGGER.warning(this.debugPrefix + "Error closing: " + ex);
        }
    }

    public void reconnect() {
        if (!this.c.isOpen()) {
            return;
        }
        LOGGER.info(this.debugPrefix + "Closing connection for reconnect");
        try {
            this.c.close();
        }
        catch (Exception ex) {
            LOGGER.warning(this.debugPrefix + "Error closing for reconnect: " + ex);
        }
    }

    public void forceReconnect() {
        if (!this.c.isOpen()) {
            return;
        }
        LOGGER.info(this.debugPrefix + "Forcing connection close for reconnect");
        try {
            this.c.closeConnection(1006, "Force reconnect");
        }
        catch (Exception ex) {
            LOGGER.warning(this.debugPrefix + "Error force close: " + ex);
        }
    }

    @Override
    public void handleReceived(String text) {
    }

    @Override
    public void handleSent(String text) {
    }

    @Override
    public void handleConnect(JWSClient c) {
    }

    @Override
    public void handleDisconnect(int code) {
    }

    public static class Received {
        public final Type type;
        public final String message;
        public final int code;

        public Received(Type type, String message, int code) {
            this.type = type;
            this.message = message;
            this.code = code;
        }

        public static enum Type {
            OPEN,
            MESSAGE,
            CLOSE;

        }
    }
}

