/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.settings;

import chatty.util.settings.Settings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AdvancedSetting<T> {
    private final Object LOCK = new Object();
    private final List<T> cache = new ArrayList<T>();
    private final Settings settings;
    private final String settingName;
    private final boolean notifyChanges;

    public AdvancedSetting(Settings settings, String settingName, boolean notifyChanges) {
        this.settings = settings;
        this.settingName = settingName;
        this.notifyChanges = notifyChanges;
    }

    public abstract T toObject(Object var1);

    public abstract Object fromObject(T var1);

    public void init() {
        this.loadSettingsIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSettingsIfNecessary() {
        List settingsList = this.settings.getList(this.settingName);
        Object object = this.LOCK;
        synchronized (object) {
            if (this.cache.isEmpty()) {
                for (Object item : settingsList) {
                    this.cache.add(this.toObject(item));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSettings() {
        ArrayList<Object> settingsData = new ArrayList<Object>();
        Object object = this.LOCK;
        synchronized (object) {
            for (T object2 : this.cache) {
                Object raw = this.fromObject(object2);
                settingsData.add(raw);
            }
        }
        this.settings.putList(this.settingName, settingsData);
        if (this.notifyChanges) {
            this.notifyChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(Collection<T> data) {
        Object object = this.LOCK;
        synchronized (object) {
            this.cache.clear();
            this.cache.addAll(data);
        }
        this.saveSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> getData() {
        Object object = this.LOCK;
        synchronized (object) {
            return new ArrayList<T>(this.cache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(T item) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.cache.contains(item);
        }
    }

    public void add(T item) {
        this.addInternal(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInternal(T item) {
        Object object = this.LOCK;
        synchronized (object) {
            this.cache.add(item);
        }
        this.settings.listAdd(this.settingName, this.fromObject(item));
        if (this.notifyChanges) {
            this.notifyChanges();
        }
    }

    public void setAdd(T item) {
        if (!this.contains(item)) {
            this.addInternal(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(T item) {
        boolean removed;
        Object object = this.LOCK;
        synchronized (object) {
            removed = this.cache.remove(item);
        }
        if (removed) {
            this.saveSettings();
        }
    }

    public void notifyChanges() {
        this.settings.setSettingChanged(this.settingName);
    }
}

