/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Setting {
    public static final int UNDEFINED = -1;
    public static final int BOOLEAN = 0;
    public static final int STRING = 1;
    public static final int LONG = 2;
    public static final int MAP = 3;
    public static final int LIST = 4;
    public static final int CHANGED = 5;
    public static final int NOT_CHANGED = 6;
    private final Object defaultValue;
    private final int type;
    private Object value;
    private boolean save = true;
    private String file;
    private boolean valueSet;

    public Setting(Object value, int type, boolean save, String file) {
        this.value = value;
        this.defaultValue = type == 3 ? new HashMap((Map)value) : (type == 4 ? Setting.copyCollection((Collection)value) : value);
        this.save = save;
        this.type = type;
        this.file = file;
    }

    public boolean allowedToSave() {
        return this.save;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isOfType(int type) {
        return type == this.type;
    }

    public int getType() {
        return this.type;
    }

    public boolean setValue(Object value) {
        this.valueSet = true;
        if (this.value.equals(value)) {
            return false;
        }
        this.value = value;
        return true;
    }

    public boolean setToDefault() {
        if (this.type == 3) {
            return this.setValue(new HashMap((Map)this.defaultValue));
        }
        if (this.type == 4) {
            return this.setValue(Setting.copyCollection((Collection)this.defaultValue));
        }
        return this.setValue(this.defaultValue);
    }

    public Object getDefault() {
        return this.defaultValue;
    }

    public boolean hasDefaultValue() {
        return this.value.equals(this.defaultValue);
    }

    public boolean isValueSet() {
        return this.valueSet;
    }

    public void setValueSet() {
        this.valueSet = true;
    }

    public void setSave(boolean save) {
        this.save = save;
    }

    public void setFile(String fileName) {
        this.file = fileName;
    }

    public String getFile() {
        return this.file;
    }

    public String toString() {
        return this.value.toString();
    }

    private static Collection copyCollection(Collection o) {
        try {
            Collection copy = null;
            copy = (Collection)o.getClass().newInstance();
            copy.addAll(o);
            return copy;
        }
        catch (Exception ex) {
            Logger.getLogger(Setting.class.getName()).log(Level.SEVERE, null, ex);
            return new ArrayList(o);
        }
    }

    private static Map copyMap(Map o) {
        try {
            Map copy = null;
            copy = (Map)o.getClass().newInstance();
            copy.putAll(o);
            return copy;
        }
        catch (Exception ex) {
            Logger.getLogger(Setting.class.getName()).log(Level.SEVERE, null, ex);
            return new HashMap(o);
        }
    }
}

