/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.settings;

import chatty.Logging;
import chatty.util.settings.FileManager;
import chatty.util.settings.Setting;
import chatty.util.settings.SettingChangeListener;
import chatty.util.settings.SettingFileNotFoundException;
import chatty.util.settings.SettingNotFoundException;
import chatty.util.settings.SettingsListener;
import chatty.util.settings.SubtypeSetting;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Settings {
    private final Object LOCK = new Object();
    private final Map<String, Setting> settings = new TreeMap<String, Setting>(String.CASE_INSENSITIVE_ORDER);
    private final Set<SettingChangeListener> listeners = new HashSet<SettingChangeListener>();
    private final Set<SettingsListener> settingsListeners = new HashSet<SettingsListener>();
    private final String defaultFile;
    private final FileManager fileManager;
    private final Set<String> files = new HashSet<String>();
    private final Set<String> fileLoaded = new HashSet<String>();
    private static final Logger LOGGER = Logger.getLogger(Settings.class.getName());

    public Settings(String path, FileManager fileManager) {
        this.defaultFile = path;
        this.fileManager = fileManager;
    }

    public void addSettingChangeListener(SettingChangeListener listener) {
        this.listeners.add(listener);
    }

    private void settingChanged(String setting, int type, Object value) {
        for (SettingChangeListener listener : this.listeners) {
            listener.settingChanged(setting, type, value);
        }
    }

    public void addSettingsListener(SettingsListener listener) {
        this.settingsListeners.add(listener);
    }

    private void aboutToSaveSettings() {
        for (SettingsListener listener : this.settingsListeners) {
            listener.aboutToSaveSettings(this);
        }
    }

    public void addFile(String fileName) {
        this.files.add(fileName);
    }

    public void setFile(String settingName, String fileName) {
        if (!this.isSetting(settingName)) {
            throw new SettingNotFoundException("Could not find setting: " + settingName);
        }
        if (!this.files.contains(fileName)) {
            throw new SettingFileNotFoundException("Could not find setting file: " + fileName);
        }
        Setting setting = this.settings.get(settingName);
        setting.setFile(fileName);
    }

    private boolean isSetting(String settingName) {
        return this.getType(settingName) != -1;
    }

    private boolean isOfType(String settingName, int type) {
        Setting obj = this.settings.get(settingName);
        return obj != null && obj.isOfType(type);
    }

    private boolean isOfSubtype(String settingName, int type) {
        Setting obj = this.settings.get(settingName);
        if (obj != null && obj instanceof SubtypeSetting) {
            return ((SubtypeSetting)obj).isOfSubType(type);
        }
        return false;
    }

    private int getType(String settingName) {
        Setting obj = this.settings.get(settingName);
        if (obj != null) {
            return obj.getType();
        }
        return -1;
    }

    public boolean isBooleanSetting(String settingName) {
        return this.isOfType(settingName, 0);
    }

    public boolean isStringSetting(String settingName) {
        return this.isOfType(settingName, 1);
    }

    public boolean isLongSetting(String settingName) {
        return this.isOfType(settingName, 2);
    }

    public boolean isMapSetting(String settingName) {
        return this.isOfType(settingName, 3);
    }

    public boolean isListSetting(String settingName) {
        return this.isOfType(settingName, 4);
    }

    public void addBoolean(String settingName, boolean value, boolean save) {
        this.add(settingName, value, 0, -1, save);
    }

    public void addString(String settingName, String value, boolean save) {
        this.add(settingName, value, 1, -1, save);
    }

    public void addLong(String settingName, long value, boolean save) {
        this.add(settingName, value, 2, -1, save);
    }

    public void addBoolean(String settingName, boolean value) {
        this.addBoolean(settingName, value, true);
    }

    public void addString(String settingName, String value) {
        this.addString(settingName, value, true);
    }

    public void addLong(String settingName, long value) {
        this.addLong(settingName, value, true);
    }

    public void addMap(String settingName, Map value, int type) {
        this.add(settingName, value, 3, type, true);
    }

    public void addList(String settingName, Collection value, int type) {
        this.add(settingName, value, 4, type, true);
    }

    public int setString(String settingName, String value) {
        return this.set(settingName, value, 1);
    }

    public int setBoolean(String settingName, boolean value) {
        return this.set(settingName, value, 0);
    }

    public int toggleBoolean(String settingName) {
        boolean currentValue = this.getBoolean(settingName);
        return this.set(settingName, !currentValue, 0);
    }

    public int setLong(String settingName, long value) {
        return this.set(settingName, value, 2);
    }

    private void add(String settingName, Object value, int type, int subType, boolean save) {
        if (type == 3 || type == 4) {
            this.settings.put(settingName, new SubtypeSetting(value, type, subType, save, this.defaultFile));
        } else {
            this.settings.put(settingName, new Setting(value, type, save, this.defaultFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int set(String settingName, Object value, int type) {
        boolean changed = false;
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.isOfType(settingName, type)) {
                throw new SettingNotFoundException("Could not find setting: " + settingName);
            }
            Setting setting = this.settings.get(settingName);
            if (value == null) {
                changed = setting.setToDefault();
                value = setting.getValue();
            } else {
                changed = setting.setValue(value);
            }
        }
        if (changed) {
            this.settingChanged(settingName, type, value);
            return 5;
        }
        return 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object get(String settingName, int type, boolean getDefault) {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.isOfType(settingName, type)) {
                throw new SettingNotFoundException("Could not find setting: " + settingName);
            }
            if (getDefault) {
                return this.settings.get(settingName).getDefault();
            }
            return this.settings.get(settingName).getValue();
        }
    }

    private Object get(String settingName, int type) {
        return this.get(settingName, type, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object get(String settingName) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.settings.get(settingName).getValue();
        }
    }

    private Setting getSetting(String settingName) {
        Setting setting = this.settings.get(settingName);
        if (setting == null) {
            throw new SettingNotFoundException("Could not find setting: " + settingName);
        }
        return setting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDefaultValue(String settingName) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.getSetting(settingName).hasDefaultValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValueSet(String settingName) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.getSetting(settingName).isValueSet();
        }
    }

    public boolean getBoolean(String settingName) {
        return (Boolean)this.get(settingName, 0);
    }

    public boolean getBooleanDefault(String settingName) {
        return (Boolean)this.get(settingName, 0, true);
    }

    public String getString(String setting) {
        return (String)this.get(setting, 1);
    }

    public String getStringDefault(String setting) {
        return (String)this.get(setting, 1, true);
    }

    public long getLong(String setting) {
        return ((Number)this.get(setting, 2)).longValue();
    }

    public int getInt(String setting) {
        return ((Number)this.get(setting, 2)).intValue();
    }

    public long getLongDefault(String settingName) {
        return (Long)this.get(settingName, 2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getMap(String settingName) {
        Object object = this.LOCK;
        synchronized (object) {
            return new HashMap(this.getMapInternal(settingName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getMap(String settingName, Map map) {
        Object object = this.LOCK;
        synchronized (object) {
            map.putAll(this.getMapInternal(settingName));
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putMap(String settingName, Map map) {
        Object object = this.LOCK;
        synchronized (object) {
            Map settingMap = this.getMapInternal(settingName);
            boolean changed = !settingMap.equals(map);
            settingMap.clear();
            settingMap.putAll(map);
            return changed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object mapGet(String settingName, Object key) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.getMapInternal(settingName).get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long mapGetLong(String settingName, Object key, long def) {
        Object object = this.LOCK;
        synchronized (object) {
            Object obj = this.getMapInternal(settingName).get(key);
            if (obj == null) {
                return def;
            }
            return (Long)obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapPut(String settingName, Object key, Object value) {
        Object object = this.LOCK;
        synchronized (object) {
            this.getMapInternal(settingName).put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapClear(String settingName) {
        Object object = this.LOCK;
        synchronized (object) {
            this.getMapInternal(settingName).clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object mapRemove(String settingName, Object key) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.getMapInternal(settingName).remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mapContainsKey(String settingName, Object key) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.getMapInternal(settingName).containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getList(String settingName) {
        Object object = this.LOCK;
        synchronized (object) {
            return new ArrayList(this.getListInternal(settingName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getList(String settingName, List list) {
        Object object = this.LOCK;
        synchronized (object) {
            list.addAll((Collection)this.get(settingName, 4));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putList(String settingName, Collection list) {
        Object object = this.LOCK;
        synchronized (object) {
            Collection settingList = (Collection)this.get(settingName, 4);
            settingList.clear();
            settingList.addAll(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean listContains(String settingName, Object value) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.getListInternal(settingName).contains(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean listRemove(String settingName, Object value) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.getListInternal(settingName).remove(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listAdd(String settingName, Object value) {
        Object object = this.LOCK;
        synchronized (object) {
            this.getListInternal(settingName).add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listClear(String settingName) {
        Object object = this.LOCK;
        synchronized (object) {
            this.getListInternal(settingName).clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long listGetLong(String settingName, int index, long defautValue) {
        Object object = this.LOCK;
        synchronized (object) {
            try {
                return (Long)((List)this.getListInternal(settingName)).get(index);
            }
            catch (IndexOutOfBoundsException ex) {
                return defautValue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setAdd(String settingName, Object value) {
        Object object = this.LOCK;
        synchronized (object) {
            Collection settingList = this.getListInternal(settingName);
            if (!settingList.contains(value)) {
                settingList.add(value);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getMapInternal(String settingName) {
        Object object = this.LOCK;
        synchronized (object) {
            return (Map)this.get(settingName, 3);
        }
    }

    private Collection getListInternal(String settingName) {
        return (Collection)this.get(settingName, 4);
    }

    public void setSettingChanged(String settingName) {
        if (this.isListSetting(settingName)) {
            this.settingChanged(settingName, 4, this.getList(settingName));
        } else if (this.isMapSetting(settingName)) {
            this.settingChanged(settingName, 3, this.getMap(settingName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String settingValueToString(String setting) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.settings.get(setting).toString();
        }
    }

    public String settingToString(String setting) {
        if (this.isBooleanSetting(setting)) {
            return "Setting '" + setting + "' is " + this.getBoolean(setting) + ".";
        }
        if (this.isLongSetting(setting)) {
            return "Setting '" + setting + "' is " + this.getLong(setting) + ".";
        }
        if (this.isStringSetting(setting)) {
            return "Setting '" + setting + "' is '" + this.getString(setting) + "'.";
        }
        if (this.isMapSetting(setting)) {
            return "Setting '" + setting + "' (Map) is '" + this.getMap(setting) + "'.";
        }
        if (this.isListSetting(setting)) {
            return "Setting '" + setting + "' (List) is '" + this.getList(setting) + "'.";
        }
        return null;
    }

    public String addTextual(String text, boolean verbose) {
        if (text == null || text.isEmpty()) {
            return "Usage: /add <setting> <value>";
        }
        String[] split = text.trim().split(" ", 2);
        if (split.length < 2) {
            return "Usage: /add <setting> <value>";
        }
        String setting = split[0];
        String parameter = split[1];
        if (this.isListSetting(setting)) {
            if (this.isOfSubtype(setting, 1)) {
                this.listAdd(setting, parameter);
                this.setSettingChanged(setting);
            } else if (this.isOfSubtype(setting, 2)) {
                try {
                    this.listAdd(setting, Long.parseLong(parameter));
                    this.setSettingChanged(setting);
                }
                catch (NumberFormatException ex) {
                    return this.settingInvalidMessage(setting);
                }
            } else {
                return this.settingInvalidMessage(setting);
            }
            if (verbose) {
                return String.format("Setting '%s' (List): Added '%s', now %s", setting, parameter, this.getList(setting));
            }
            return String.format("Setting '%s' (List): Added '%s'", setting, parameter);
        }
        return this.settingInvalidMessage(setting);
    }

    public String addUniqueTextual(String text, boolean verbose) {
        if (text == null || text.isEmpty()) {
            return "Usage: /addUnique <setting> <value>";
        }
        String[] split = text.trim().split(" ", 2);
        if (split.length < 2) {
            return "Usage: /addUnique <setting> <value>";
        }
        String setting = split[0];
        String parameter = split[1];
        if (this.isListSetting(setting)) {
            Object value;
            if (this.isOfSubtype(setting, 1)) {
                value = parameter;
            } else if (this.isOfSubtype(setting, 2)) {
                try {
                    value = Long.parseLong(parameter);
                }
                catch (NumberFormatException ex) {
                    return this.settingInvalidMessage(setting);
                }
            } else {
                return this.settingInvalidMessage(setting);
            }
            boolean changed = this.setAdd(setting, value);
            if (changed) {
                this.setSettingChanged(setting);
                if (verbose) {
                    return String.format("Setting '%s' (List): Added '%s', now %s", setting, parameter, this.getList(setting));
                }
                return String.format("Setting '%s' (List): Added '%s'", setting, parameter);
            }
            if (verbose) {
                return String.format("Setting '%s' (List): Value '%s' already found (nothing changed), currently %s", setting, parameter, this.getList(setting));
            }
            return String.format("Setting '%s' (List): Value '%s' already found (nothing changed)", setting, parameter);
        }
        return this.settingInvalidMessage(setting);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String removeTextual(String text, boolean verbose) {
        if (text == null || text.isEmpty()) {
            return "Usage: /remove <setting> <value>";
        }
        String[] split = text.trim().split(" ", 2);
        if (split.length < 2) {
            return "Usage: /remove <setting> <value>";
        }
        String setting = split[0];
        String parameter = split[1];
        if (this.isListSetting(setting)) {
            boolean removed = false;
            if (this.isOfSubtype(setting, 1)) {
                removed = this.listRemove(setting, parameter);
                if (removed) {
                    this.setSettingChanged(setting);
                }
            } else {
                if (!this.isOfSubtype(setting, 2)) return this.settingInvalidMessage(setting);
                try {
                    removed = this.listRemove(setting, Long.parseLong(parameter));
                    if (removed) {
                        this.setSettingChanged(setting);
                    }
                }
                catch (NumberFormatException ex) {
                    return this.settingInvalidMessage(setting);
                }
            }
            if (removed) {
                if (!verbose) return String.format("Setting '%s' (List): Removed '%s'", setting, parameter);
                return String.format("Setting '%s' (List): Removed '%s', now %s", setting, parameter, this.getList(setting));
            }
            if (!verbose) return String.format("Setting '%s' (List): Value '%s' not found (nothing changed)", setting, parameter);
            return String.format("Setting '%s' (List): Value '%s' not found (nothing changed), currently %s", setting, parameter, this.getList(setting));
        }
        if (!this.isMapSetting(setting)) return this.settingInvalidMessage(setting);
        if (this.mapContainsKey(setting, parameter)) {
            Object removedValue = this.mapRemove(setting, parameter);
            this.setSettingChanged(setting);
            if (!verbose) return String.format("Setting '%s' (Map): Removed '%s' ('%s')", setting, parameter, removedValue);
            return String.format("Setting '%s' (Map): Removed '%s' ('%s'), now %s", setting, parameter, removedValue, this.getMap(setting));
        }
        if (!verbose) return String.format("Setting '%s' (Map): Key '%s' not found (nothing changed)", setting, parameter);
        return String.format("Setting '%s' (Map): Key '%s' not found (nothing changed), currently %s", setting, parameter, this.getMap(setting));
    }

    public String setSwitchTextual(String text, boolean verbose) {
        String currentValue;
        String[] values;
        if (text == null || text.isEmpty()) {
            return "Usage: /setSwitch <setting> <value>,<value2>";
        }
        String[] split = text.split(" ", 2);
        if (split.length < 2) {
            return "Usage: /setSwitch <setting> <value>,<value2>";
        }
        String setting = split[0];
        String parameter = split[1];
        String key = "";
        if (this.isMapSetting(setting)) {
            String[] mapParameters = parameter.split(" ", 2);
            values = mapParameters[1].split(",");
            currentValue = String.valueOf(this.mapGet(setting, mapParameters[0]));
            key = " " + mapParameters[0];
        } else {
            values = parameter.split(",");
            currentValue = String.valueOf(this.get(setting));
        }
        String nextValue = null;
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals(currentValue)) continue;
            nextValue = values[(i + 1) % values.length];
            break;
        }
        if (nextValue == null) {
            nextValue = values[0];
        }
        return this.setTextual(setting + key + " " + nextValue, verbose);
    }

    public String setTextual(String text, boolean verbose) {
        if (text == null || text.isEmpty()) {
            return "Usage: /set <setting> <value>";
        }
        String[] split = text.split(" ", 2);
        if (split.length < 2) {
            return "Usage: /set <setting> <value>";
        }
        String setting = split[0];
        String parameter = split[1];
        if (this.isBooleanSetting(setting)) {
            boolean value = false;
            if (parameter.equals("1") || parameter.equals("true") || parameter.equals("on")) {
                value = true;
            }
            if (parameter.equals("!")) {
                value = !this.getBoolean(setting);
            }
            this.setBoolean(setting, value);
            return "Setting '" + setting + "' set to " + value + ".";
        }
        if (this.isStringSetting(setting)) {
            this.setString(setting, parameter);
            return "Setting '" + setting + "' set to '" + parameter + "'.";
        }
        if (this.isLongSetting(setting)) {
            long value = 0L;
            try {
                value = Long.parseLong(parameter);
            }
            catch (NumberFormatException ex) {
                return "Invalid value (must be numeric for this setting).";
            }
            this.setLong(setting, value);
            return "Setting '" + setting + "' set to '" + parameter + "'.";
        }
        if (this.isListSetting(setting) && this.isOfSubtype(setting, 1)) {
            this.listClear(setting);
            this.listAdd(setting, parameter);
            this.setSettingChanged(setting);
            String warning = "";
            if (parameter.contains(",")) {
                warning = " (Note: Using commas in '/set' only sets a single list item that contains the commas, use '/setList' to set as separate items or '/add' to add a single item)";
            }
            return String.format("Setting '%s' (List): Set to %s%s", setting, this.getList(setting), warning);
        }
        if (this.isMapSetting(setting) && (this.isOfSubtype(setting, 1) || this.isOfSubtype(setting, 2))) {
            String[] mapParameters = parameter.split(" ", 2);
            if (mapParameters.length != 2) {
                return "Invalid number of parameters to set map value.";
            }
            Object value = mapParameters[1];
            if (this.isOfSubtype(setting, 2)) {
                try {
                    value = Long.valueOf(mapParameters[1]);
                }
                catch (NumberFormatException ex) {
                    return "Invalid value (must be numeric).";
                }
            }
            this.mapPut(setting, mapParameters[0], value);
            this.setSettingChanged(setting);
            if (verbose) {
                return String.format("Setting '%s' (Map): Set '%s' to '%s', now %s", setting, mapParameters[0], value, this.getMap(setting));
            }
            return String.format("Setting '%s' (Map): Set '%s' to '%s'", setting, mapParameters[0], value);
        }
        return this.settingInvalidMessage(setting);
    }

    public String setListTextual(String text) {
        if (text == null || text.isEmpty()) {
            return "Usage: /setList <setting> <value>,<value2>";
        }
        String[] split = text.split(" ", 2);
        if (split.length < 2) {
            return "Usage: /setList <setting> <value>,<value2>";
        }
        String setting = split[0];
        String parameter = split[1];
        String[] values = parameter.split(",");
        if (this.isListSetting(setting)) {
            if (this.isOfSubtype(setting, 1)) {
                this.listClear(setting);
                for (String value : values) {
                    this.listAdd(setting, value.trim());
                }
                this.setSettingChanged(setting);
            } else if (this.isOfSubtype(setting, 2)) {
                ArrayList<Long> numericValues = new ArrayList<Long>();
                for (String value : values) {
                    try {
                        numericValues.add(Long.parseLong(value.trim()));
                    }
                    catch (NumberFormatException ex) {
                        return String.format("Setting '%s' (List): Invalid value (must be numeric), nothing changed.", setting);
                    }
                }
                this.listClear(setting);
                for (Long value : numericValues) {
                    this.listAdd(setting, value);
                }
                this.setSettingChanged(setting);
            } else {
                return this.settingInvalidMessage(setting);
            }
            return String.format("Setting '%s' (List): Set to %s", setting, this.getList(setting));
        }
        return this.settingInvalidMessage(setting);
    }

    public String resetTextual(String text) {
        if (text == null || text.isEmpty()) {
            return "Usage: /reset <setting>";
        }
        String[] split = text.split(" ", 2);
        String settingName = split[0];
        if (this.getType(settingName) != -1) {
            int result = this.set(settingName, null, this.getType(settingName));
            Object value = this.get(settingName);
            if (result == 5) {
                return "Setting '" + settingName + "' reset to default (" + value.toString() + ")";
            }
            return "Setting '" + settingName + "' already default (" + value.toString() + ")";
        }
        return "Setting does not exist.";
    }

    public String getTextual(String text) {
        if (text == null || text.isEmpty()) {
            return "Usage: /get <setting>";
        }
        String[] split = text.split(" ", 2);
        String setting = split[0];
        if (split.length == 2 && this.isMapSetting(setting)) {
            String key = split[1];
            if (this.mapContainsKey(setting, key)) {
                return String.format("Setting '%s' (Map) key '%s' has value '%s'.", setting, key, this.mapGet(setting, key));
            }
            return String.format("Setting '%s' (Map) does not contain key '%s'.", setting, key);
        }
        String output = this.settingToString(setting);
        if (output != null) {
            return output;
        }
        return "Setting does not exist.";
    }

    public String clearTextual(String text) {
        if (text == null || text.isEmpty()) {
            return "Usage: /clearSetting <setting>";
        }
        String[] split = text.split(" ");
        String setting = split[0];
        if (this.isBooleanSetting(setting)) {
            return "Boolean settings can't be cleared.";
        }
        if (this.isLongSetting(setting)) {
            return "Numeric settings can't be cleared.";
        }
        if (this.isStringSetting(setting)) {
            this.setString(setting, "");
            return "Setting '" + setting + "' set to empty string.";
        }
        if (this.isListSetting(setting)) {
            this.listClear(setting);
            this.setSettingChanged(setting);
            return "Setting '" + setting + "' is now empty.";
        }
        if (this.isMapSetting(setting)) {
            this.mapClear(setting);
            this.setSettingChanged(setting);
            return "Setting '" + setting + "' is now empty.";
        }
        return this.settingInvalidMessage(setting);
    }

    private String settingInvalidMessage(String setting) {
        if (this.isSetting(setting)) {
            return "Invalid setting: '" + setting + "' (can't change with this command).";
        }
        return "Invalid setting: '" + setting + "'.";
    }

    private String settingsToJson(String file) {
        JSONObject obj = new JSONObject();
        Set<Map.Entry<String, Setting>> set = this.settings.entrySet();
        for (Map.Entry<String, Setting> entry : set) {
            Setting setting = entry.getValue();
            if (!setting.allowedToSave() || !setting.getFile().equals(file)) continue;
            String key = entry.getKey();
            ArrayList value = setting.getValue();
            if (value instanceof Collection) {
                value = new ArrayList(value);
            }
            obj.put(key, value);
        }
        if (obj.isEmpty()) {
            return null;
        }
        return obj.toJSONString();
    }

    private void settingsFromJson(String json) throws ParseException {
        JSONParser parser = new JSONParser();
        JSONObject root = (JSONObject)parser.parse(json);
        for (Map.Entry<String, Setting> entry : this.settings.entrySet()) {
            int objType;
            Setting setting = entry.getValue();
            String settingName = entry.getKey();
            Object obj = root.get(settingName);
            if (!setting.allowedToSave() || (objType = this.getTypeFromObject(obj)) != setting.getType()) continue;
            if (objType == 3) {
                this.mapFromJson((Map)obj, (SubtypeSetting)setting);
                continue;
            }
            if (objType == 4) {
                this.listFromJson((List)obj, (SubtypeSetting)setting);
                continue;
            }
            setting.setValue(obj);
        }
    }

    private void mapFromJson(Map map, SubtypeSetting setting) {
        Map settingMap = (Map)setting.getValue();
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            if (this.getTypeFromObject(value) != setting.getSubType()) continue;
            settingMap.put(key, value);
        }
        setting.setValueSet();
    }

    private void listFromJson(List list, SubtypeSetting setting) {
        Collection settingList = (Collection)setting.getValue();
        settingList.clear();
        for (Object value : list) {
            if (this.getTypeFromObject(value) != setting.getSubType()) continue;
            settingList.add(value);
        }
        setting.setValueSet();
    }

    private int getTypeFromObject(Object obj) {
        if (obj instanceof Number) {
            return 2;
        }
        if (obj instanceof String) {
            return 1;
        }
        if (obj instanceof Boolean) {
            return 0;
        }
        if (obj instanceof Map) {
            return 3;
        }
        if (obj instanceof List) {
            return 4;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileManager.SaveResult> saveSettingsToJson(boolean force) {
        ArrayList<FileManager.SaveResult> result = new ArrayList<FileManager.SaveResult>();
        this.aboutToSaveSettings();
        Object object = this.LOCK;
        synchronized (object) {
            System.out.println("Saving settings to JSON.");
            result.add(this.saveSettingsToJson(this.defaultFile, force));
            for (String fileName : this.files) {
                result.add(this.saveSettingsToJson(fileName, force));
            }
        }
        return result;
    }

    private FileManager.SaveResult saveSettingsToJson(String fileName, boolean force) {
        String json = this.settingsToJson(fileName);
        FileManager.SaveResult result = this.fileManager.save(fileName, json, force);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSettingsFromJson() {
        Object object = this.LOCK;
        synchronized (object) {
            boolean success = this.loadSettingsFromJson(this.defaultFile);
            for (String fileName : this.files) {
                if (this.loadSettingsFromJson(fileName)) continue;
                success = false;
            }
            return success;
        }
    }

    private boolean loadSettingsFromJson(String fileId) {
        LOGGER.info("Loading settings from file: " + fileId);
        try {
            String input = this.fileManager.load(fileId);
            try {
                this.settingsFromJson(input);
            }
            catch (ParseException ex) {
                Settings.logParseError(fileId, input, ex);
                return false;
            }
        }
        catch (FileNotFoundException | NoSuchFileException ex) {
            LOGGER.warning("File not found: " + ex);
            return true;
        }
        catch (IOException ex) {
            LOGGER.warning("Error loading settings from file: " + ex);
            return false;
        }
        this.fileLoaded.add(fileId);
        return true;
    }

    public boolean wasFileLoaded(String fileName) {
        return this.fileLoaded.contains(fileName);
    }

    private static void logParseError(String fileId, String input, ParseException ex) {
        int pos = ex.getPosition();
        int start = pos - 10;
        int end = pos + 10;
        start = start < 0 ? 0 : start;
        end = end > input.length() ? input.length() : end;
        String excerpt = input.substring(start, pos) + "@" + input.substring(pos, end);
        LOGGER.warning("Error parsing settings: " + ex + "[" + excerpt + "]");
        LOGGER.log(Logging.USERINFO, String.format("Settings file corrupt, using default settings (%s) [%s]", fileId, excerpt));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getSettingNames() {
        Object object = this.LOCK;
        synchronized (object) {
            return new HashSet<String>(this.settings.keySet());
        }
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }
}

