/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.seventv;

import chatty.Helper;
import chatty.util.Debugging;
import chatty.util.EmoticonListener;
import chatty.util.JSONUtil;
import chatty.util.MiscUtil;
import chatty.util.RetryManager;
import chatty.util.StringUtil;
import chatty.util.UrlRequest;
import chatty.util.api.Emoticon;
import chatty.util.api.EmoticonUpdate;
import chatty.util.api.TwitchApi;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class SevenTV {
    private static final Logger LOGGER = Logger.getLogger(SevenTV.class.getName());
    private final EmoticonListener listener;
    private final TwitchApi api;

    public SevenTV(EmoticonListener listener, TwitchApi api) {
        this.listener = listener;
        this.api = api;
    }

    public synchronized void requestEmotes(String channel, boolean forcedUpdate) {
        channel = Helper.toStream(channel);
        if (StringUtil.isNullOrEmpty(channel)) {
            this.requestEmotes(Type.GLOBAL, null, null, forcedUpdate);
        } else {
            String stream = channel;
            this.api.getUserId(r -> {
                if (!r.hasError()) {
                    this.requestEmotes(Type.CHANNEL, stream, r.getId(stream), forcedUpdate);
                }
            }, stream);
        }
    }

    private void requestEmotes(Type type, String stream, String streamId, boolean forcedUpdate) {
        String url = SevenTV.getUrl(type, streamId);
        if (forcedUpdate) {
            this.requestNow(type, stream, url);
        } else {
            RetryManager.getInstance().retry(url, k -> this.requestNow(type, stream, url));
        }
    }

    private static String getUrl(Type type, String streamId) {
        switch (type) {
            case GLOBAL: {
                return "https://7tv.io/v3/emote-sets/global";
            }
            case CHANNEL: {
                return String.format("https://7tv.io/v3/users/twitch/%s", streamId);
            }
        }
        return null;
    }

    private void requestNow(Type type, String stream, String url) {
        UrlRequest request = new UrlRequest();
        request.setLabel("SevenTV/" + stream);
        request.setUrl(url);
        request.async((result, responseCode) -> {
            if (Integer.toString(responseCode).startsWith("4")) {
                RetryManager.getInstance().setNotFound(url);
            } else if (responseCode != 200 && result == null) {
                RetryManager.getInstance().setError(url);
            } else {
                RetryManager.getInstance().setSuccess(url);
            }
            this.parseResult(type, stream, result);
        });
    }

    private void parseResult(Type type, String stream, String json) {
        if (json == null) {
            return;
        }
        Set<Emoticon> emotes = this.parseEmoteList(type, stream, json);
        LOGGER.info(String.format("|[SevenTV] (%s): %d emotes received.", stream, emotes.size()));
        EmoticonUpdate.Builder updateBuilder = new EmoticonUpdate.Builder(emotes);
        updateBuilder.setTypeToRemove(Emoticon.Type.SEVENTV);
        if (type == Type.CHANNEL) {
            updateBuilder.setRoomToRemove(stream);
        }
        this.listener.receivedEmoticons(updateBuilder.build());
    }

    private Set<Emoticon> parseEmoteList(Type type, String stream, String json) {
        HashSet<Emoticon> result = new HashSet<Emoticon>();
        try {
            JSONObject root;
            JSONParser parser = new JSONParser();
            JSONObject set = root = (JSONObject)parser.parse(json);
            if (type == Type.CHANNEL) {
                set = (JSONObject)root.get("emote_set");
            }
            if (set != null) {
                JSONArray emotes = (JSONArray)set.get("emotes");
                for (Object o : emotes) {
                    Emoticon emote;
                    if (!(o instanceof JSONObject) || (emote = this.parseEmote(stream, (JSONObject)o)) == null) continue;
                    result.add(emote);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warning("Error parsing SevenTV emote list: " + ex);
        }
        return result;
    }

    private Emoticon parseEmote(String stream, JSONObject emoteObject) {
        try {
            String id = JSONUtil.getString(emoteObject, "id");
            String code = JSONUtil.getString(emoteObject, "name");
            JSONObject data = (JSONObject)emoteObject.get("data");
            boolean animated = JSONUtil.getBoolean(data, "animated", false);
            JSONObject host = (JSONObject)data.get("host");
            List<File> files = this.getFiles(host);
            if (files == null) {
                LOGGER.warning("SevenTV emote: No file found");
                return null;
            }
            int width = Integer.MAX_VALUE;
            int height = Integer.MAX_VALUE;
            Emoticon.Builder b = new Emoticon.Builder(Emoticon.Type.SEVENTV, code);
            for (File file : files) {
                width = Integer.min(width, file.width);
                height = Integer.min(height, file.height);
            }
            for (File file : files) {
                int scale = file.width / width;
                b.addUrl(scale, file.url);
            }
            b.setSize(width, height);
            b.setStringId(id);
            b.setAnimated(animated);
            b.setLiteral(true);
            b.setZeroWidth(MiscUtil.isBitEnabled(JSONUtil.getInteger(data, "flags", 0), 256));
            if (stream != null) {
                b.addStreamRestriction(stream);
            }
            return b.build();
        }
        catch (Exception ex) {
            LOGGER.warning("Error parsing SevenTV emote: " + Debugging.getStacktrace(ex));
            return null;
        }
    }

    private List<File> getFiles(JSONObject host) {
        String baseUrl = JSONUtil.getString(host, "url");
        if (baseUrl == null) {
            return null;
        }
        ArrayList<File> result = new ArrayList<File>();
        JSONArray files = (JSONArray)host.get("files");
        for (Object o : files) {
            JSONObject file = (JSONObject)o;
            if (!file.get("format").equals("WEBP")) continue;
            String name = (String)file.get("name");
            int width = JSONUtil.getInteger(file, "width", -1);
            int height = JSONUtil.getInteger(file, "height", -1);
            result.add(new File(baseUrl + "/" + name, width, height));
        }
        return result;
    }

    private static enum Type {
        GLOBAL,
        CHANNEL;

    }

    private static class File {
        public final String url;
        public final int width;
        public final int height;

        private File(String url, int width, int height) {
            this.url = url;
            this.width = width;
            this.height = height;
        }
    }
}

