/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.seventv;

import chatty.util.ImageCache;
import chatty.util.gif.GifUtil;
import chatty.util.gif.ListAnimatedImage;
import chatty.util.gif.ListAnimatedImageFrame;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import webpdecoderjn.WebPDecoder;

public class WebPUtil {
    private static final Logger LOGGER = Logger.getLogger(WebPUtil.class.getName());
    private static final Object LOCK = new Object();
    private static final List<Runnable> waiting = new ArrayList<Runnable>();
    private static boolean useWebP;
    private static boolean checking;
    private static boolean checked;
    private static boolean available;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runIfWebPAvailable(Runnable runnable) {
        if (WebPUtil.isAvailable()) {
            runnable.run();
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            if (!checked) {
                waiting.add(runnable);
                if (!checking) {
                    checking = true;
                    new Thread(() -> {
                        boolean success = WebPUtil.check();
                        ArrayList<Runnable> runNow = new ArrayList<Runnable>();
                        Iterator iterator = LOCK;
                        synchronized (iterator) {
                            available = success;
                            checking = false;
                            checked = true;
                            if (available) {
                                runNow.addAll(waiting);
                            }
                            waiting.clear();
                        }
                        for (Runnable waitingRunnable : runNow) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException ex) {
                                break;
                            }
                            waitingRunnable.run();
                        }
                    }, "WebP Check").start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUseWebP(boolean enabled) {
        Object object = LOCK;
        synchronized (object) {
            useWebP = enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldUseWebP() {
        Object object = LOCK;
        synchronized (object) {
            return useWebP && WebPUtil.isAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAvailable() {
        Object object = LOCK;
        synchronized (object) {
            return available;
        }
    }

    private static boolean check() {
        try {
            WebPDecoder.init();
            boolean success = WebPDecoder.test();
            LOGGER.info("WebP Decoding available: " + success);
            return success;
        }
        catch (IOException | UnsatisfiedLinkError ex) {
            LOGGER.warning("Error checking WebP: " + ex);
            return false;
        }
    }

    public static ImageCache.ImageResult decode(byte[] data, ImageCache.ImageRequest request) {
        if (!available) {
            return null;
        }
        try {
            WebPDecoder.WebPImage img = WebPDecoder.decode(data);
            Dimension size = new Dimension();
            Dimension actualBaseSize = request.getUrlFactorCorrectedSize(img.canvasWidth, img.canvasHeight);
            Dimension scaledSize = request.getScaledSizeIfNecessary(actualBaseSize);
            if (img.frameCount == 1) {
                ImageIcon icon = new ImageIcon(img.frames.get((int)0).img);
                icon.setDescription("WebP");
                return request.finishIcon(icon, false);
            }
            ArrayList<ListAnimatedImageFrame> frames = new ArrayList<ListAnimatedImageFrame>();
            for (WebPDecoder.WebPImageFrame frame : img.frames) {
                BufferedImage image = frame.img;
                if (scaledSize != null) {
                    image = GifUtil.resize(image, scaledSize.width, scaledSize.height);
                }
                size = new Dimension(image.getWidth(), image.getHeight());
                frames.add(new ListAnimatedImageFrame(image, frame.delay));
            }
            ImageIcon icon = new ImageIcon(new ListAnimatedImage(frames, size.width, size.height, request.getRequestedURL().toString()).createImage());
            icon.setDescription("WebP (animated)");
            return new ImageCache.ImageResult(icon, actualBaseSize, false);
        }
        catch (IOException | UnsatisfiedLinkError ex) {
            LOGGER.warning(String.format("Error decoding %s: %s", request.getRequestedURL().toString(), ex));
            return null;
        }
    }
}

