/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.srl;

import chatty.Helper;
import java.util.Collection;
import java.util.Objects;
import java.util.TreeSet;

public class Race {
    public static final int ENTRY_OPEN = 1;
    public static final int ENTRY_CLOSED = 2;
    public static final int IN_PROGRESS = 3;
    public static final int COMPLETE = 4;
    public static final int RACE_OVER = 5;
    public final String game;
    public final String id;
    public final int state;
    public final String statetext;
    public final long time;
    public final String goal;
    private final Collection<Entrant> entrants;

    public Race(String id, String game, String goal, int state, String statetext, long time) {
        this.id = id;
        this.game = game;
        this.goal = Helper.htmlspecialchars_decode(goal);
        this.state = state;
        this.statetext = statetext;
        this.time = time * 1000L;
        this.entrants = new TreeSet<Entrant>();
    }

    public void addEntrant(Entrant entrant) {
        this.entrants.add(entrant);
    }

    public Collection<Entrant> getEntrants() {
        return this.entrants;
    }

    public String toString() {
        return this.game + " - " + this.goal + " (" + this.statetext + ")";
    }

    public boolean equals(Object other) {
        if (other instanceof Race) {
            Race otherRace = (Race)other;
            return this.id.equals(otherRace.id);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public static class Entrant
    implements Comparable<Entrant> {
        public final String name;
        public final String statetext;
        public final int place;
        public final long time;
        public final String twitch;
        public final int points;
        public final String message;

        public Entrant(String name, String statetext, int place, long time, String twitch, int points, String message) {
            this.name = name;
            this.statetext = statetext;
            this.place = place;
            this.time = time;
            this.twitch = twitch;
            this.points = points;
            this.message = message != null ? message : "";
        }

        public String toString() {
            return this.name + " (" + this.statetext + "/" + this.twitch + ")";
        }

        @Override
        public int compareTo(Entrant o) {
            if (this.place > o.place) {
                return 1;
            }
            if (this.place < o.place) {
                return -1;
            }
            return this.name.compareTo(o.name);
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof Entrant)) {
                return false;
            }
            return this.name.equals(((Entrant)other).name);
        }

        public int hashCode() {
            int hash = 3;
            hash = 59 * hash + Objects.hashCode(this.name);
            return hash;
        }
    }
}

