/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.srl;

import chatty.util.UrlRequest;
import chatty.util.srl.Race;
import chatty.util.srl.SpeedrunsLiveListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class SpeedrunsLive {
    private static final Logger LOGGER = Logger.getLogger(SpeedrunsLive.class.getName());
    private volatile boolean requestPending;
    private final List<SpeedrunsLiveListener> listeners = new ArrayList<SpeedrunsLiveListener>();

    public void requestRaces() {
        if (!this.requestPending) {
            this.requestPending = true;
            new SpeedrunsLiveRequest().async((result, responseCode) -> this.result(result, responseCode));
        }
    }

    public void addListener(SpeedrunsLiveListener listener) {
        this.listeners.add(listener);
    }

    private void result(String result, int responseCode) {
        this.requestPending = false;
        if (result == null || responseCode != 200) {
            this.error("Error receiving data.");
            return;
        }
        List<Race> races = this.parseRaces(result);
        if (races == null) {
            this.error("Error parsing data.");
        } else {
            for (SpeedrunsLiveListener listener : this.listeners) {
                listener.racesReceived(races);
            }
        }
    }

    private void error(String description) {
        for (SpeedrunsLiveListener listener : this.listeners) {
            listener.error(description);
        }
    }

    private List<Race> parseRaces(String json) {
        ArrayList<Race> result = new ArrayList<Race>();
        if (json == null) {
            return null;
        }
        JSONParser parser = new JSONParser();
        try {
            JSONObject root = (JSONObject)parser.parse(json.trim());
            JSONArray races = (JSONArray)root.get("races");
            for (Object o : races) {
                Race race;
                if (!(o instanceof JSONObject) || (race = this.parseRace((JSONObject)o)) == null) continue;
                result.add(race);
            }
        }
        catch (ClassCastException | NullPointerException | ParseException ex) {
            LOGGER.warning("Error parsing SRL: " + ex);
            return null;
        }
        return result;
    }

    private Race parseRace(JSONObject o) {
        try {
            String id = (String)o.get("id");
            JSONObject gameInfo = (JSONObject)o.get("game");
            String game = (String)gameInfo.get("name");
            String goal = (String)o.get("goal");
            int state = ((Number)o.get("state")).intValue();
            String statetext = (String)o.get("statetext");
            long time = ((Number)o.get("time")).longValue();
            Race race = new Race(id, game, goal, state, statetext, time);
            JSONObject entrants = (JSONObject)o.get("entrants");
            this.parseEntrants(entrants, race);
            return race;
        }
        catch (ClassCastException | NullPointerException | NumberFormatException ex) {
            LOGGER.warning("Error parsing race: " + ex);
            return null;
        }
    }

    private void parseEntrants(JSONObject o, Race race) {
        for (Object key : o.keySet()) {
            JSONObject entrant = (JSONObject)o.get(key);
            String name = (String)entrant.get("displayname");
            String statetext = (String)entrant.get("statetext");
            int place = ((Number)entrant.get("place")).intValue();
            long time = ((Number)entrant.get("time")).longValue();
            String twitch = (String)entrant.get("twitch");
            int points = Integer.parseInt((String)entrant.get("trueskill"));
            String message = (String)entrant.get("message");
            race.addEntrant(new Race.Entrant(name, statetext, place, time, twitch, points, message));
        }
    }

    public static final void main(String[] args) {
        SpeedrunsLive srl = new SpeedrunsLive();
        srl.requestRaces();
    }

    private class SpeedrunsLiveRequest
    extends UrlRequest {
        private static final String URL = "https://api.speedrunslive.com/races";

        private SpeedrunsLiveRequest() {
            super(URL);
        }
    }
}

