/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.tts;

import chatty.util.tts.SpeakRequest;
import chatty.util.tts.TTSProvider;
import chatty.util.tts.VoiceInfo;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class MacTTSProvider
implements TTSProvider {
    private static final Logger LOGGER = Logger.getLogger(MacTTSProvider.class.getName());

    @Override
    public void speak(SpeakRequest request) throws Exception {
        ArrayList<String> command = new ArrayList<String>();
        command.add("say");
        command.add("-v");
        command.add(request.voice);
        command.add("-r");
        command.add(String.valueOf(request.rate));
        command.add(request.text);
        ProcessBuilder pb = new ProcessBuilder(command);
        Process process = pb.start();
        process.waitFor();
        if (process.exitValue() != 0) {
            throw new Exception("macOS TTS failed with exit code: " + process.exitValue());
        }
    }

    @Override
    public void stop() {
        try {
            ProcessBuilder pb = new ProcessBuilder("pkill", "say");
            pb.start();
        }
        catch (Exception e) {
            LOGGER.warning("Failed to stop macOS TTS: " + e.getMessage());
        }
    }

    @Override
    public List<VoiceInfo> getAvailableVoices() {
        ArrayList<VoiceInfo> voices = new ArrayList<VoiceInfo>();
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder("say", "-v", "?");
            Process process = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                String[] parts = line.trim().split("\\s+");
                if (parts.length < 2) continue;
                String name = parts[0];
                String locale = parts[1];
                voices.add(new VoiceInfo(name, null, locale));
            }
            process.waitFor();
        }
        catch (Exception e) {
            LOGGER.warning("Failed to get macOS voices: " + e.getMessage());
            voices.add(new VoiceInfo("Alex", null, "en_US"));
            voices.add(new VoiceInfo("Victoria", null, "en_US"));
            voices.add(new VoiceInfo("Daniel", null, "en_GB"));
        }
        return voices;
    }

    @Override
    public String getProviderId() {
        return "Mac";
    }
}

