/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.tts;

import chatty.User;
import chatty.util.Debugging;
import chatty.util.Sound;
import chatty.util.irc.MsgTags;
import chatty.util.settings.Settings;
import chatty.util.tts.FallbackTTSProvider;
import chatty.util.tts.SpeakRequest;
import chatty.util.tts.TTSProvider;
import chatty.util.tts.VoiceInfo;
import chatty.util.tts.WindowsTTSProvider;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

public class TextToSpeech {
    private static final Logger LOGGER = Logger.getLogger(TextToSpeech.class.getName());
    private static TextToSpeech instance;
    private final LinkedList<SpeakRequest> queue;
    private final LinkedList<SpeakRequest> doneQueue;
    private SpeakRequest directRequest;
    private Thread thread;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition queueNotEmpty = this.lock.newCondition();
    private final Condition unpaused = this.lock.newCondition();
    private final AtomicBoolean isPaused;
    private final AtomicBoolean speakingInterrupted;
    private final AtomicBoolean currentlySpeaking;
    private final AtomicBoolean shutdown;
    private final Settings settings;
    private final TTSProvider ttsProvider;
    private static final int DONE_QUEUE_LIMIT = 100;
    private static final String SOUND_ERROR = "error.wav";
    private static final String SOUND_MUTE = "mute.wav";
    private static final String SOUND_UNMUTE = "unmute.wav";
    private static final String SOUND_ON = "on.wav";
    private static final String SOUND_OFF = "off.wav";
    private static final String SOUND_CLEARQUEUE = "clearqueue.wav";

    public static synchronized TextToSpeech get(Settings settings) {
        if (instance == null) {
            instance = new TextToSpeech(settings);
        }
        return instance;
    }

    public static synchronized void shutdownIfNecessary() {
        if (instance != null) {
            instance.shutdown();
        }
    }

    private TextToSpeech(Settings settings) {
        this.settings = settings;
        this.queue = new LinkedList();
        this.doneQueue = new LinkedList();
        this.isPaused = new AtomicBoolean(false);
        this.speakingInterrupted = new AtomicBoolean();
        this.currentlySpeaking = new AtomicBoolean();
        this.shutdown = new AtomicBoolean();
        String os = System.getProperty("os.name").toLowerCase();
        this.ttsProvider = os.contains("win") ? new WindowsTTSProvider() : new FallbackTTSProvider();
        LOGGER.info("TTS initialized with provider: " + this.ttsProvider.getClass().getSimpleName());
    }

    public boolean speak(String text) {
        return this.speak(text, (String)this.settings.mapGet("ttsVoice", this.ttsProvider.getProviderId()), this.settings.getInt("ttsVolume"), this.settings.getInt("ttsRate"), this.settings.getInt("ttsPitch"), SpeakRequest.Mode.QUEUE);
    }

    public void message(User user, String text, MsgTags tags, boolean ownMessage) {
        if (ownMessage) {
            return;
        }
        if (!this.settings.getBoolean("ttsReadMessages")) {
            return;
        }
        if (this.settings.getBoolean("ttsIgnoreEmoteOnly") && tags != null && tags.isValue("emote-only", "1")) {
            return;
        }
        this.speak(String.format("%s says: %s", user.getName(), text));
    }

    public boolean hasProvider() {
        return !this.ttsProvider.getProviderId().isEmpty();
    }

    public boolean checkProvider() {
        if (!this.hasProvider()) {
            this.playSound(SOUND_ERROR);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean speak(String text, String voice, int volume, int rate, int pitch, SpeakRequest.Mode mode) {
        String sanitizedText;
        if (this.settings == null || !this.settings.getBoolean("ttsEnabled") || !this.hasProvider() || text == null || text.trim().isEmpty()) {
            return false;
        }
        if (this.thread == null) {
            this.thread = new Thread(() -> this.readQueue());
            this.thread.setDaemon(true);
            this.thread.start();
        }
        if ((sanitizedText = text).trim().isEmpty()) {
            return false;
        }
        if (sanitizedText.length() > this.settings.getInt("ttsMaxLength")) {
            sanitizedText = sanitizedText.substring(0, this.settings.getInt("ttsMaxLength")) + " [text shortened]";
        }
        SpeakRequest request = new SpeakRequest(sanitizedText, voice, volume, rate, pitch, mode);
        this.lock.lock();
        try {
            if (mode == SpeakRequest.Mode.QUEUE) {
                this.queue.addLast(request);
            } else if (mode == SpeakRequest.Mode.STOP_SAY_DIRECTLY) {
                this.directRequest = request;
            }
            this.queueNotEmpty.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        if (mode == SpeakRequest.Mode.STOP_SAY_DIRECTLY) {
            this.interruptSpeaking();
        }
        return true;
    }

    private void speakInternal(SpeakRequest request) {
        try {
            this.ttsProvider.speak(request);
        }
        catch (Exception e) {
            LOGGER.warning("TTS error: " + Debugging.getStacktrace(e));
        }
    }

    private SpeakRequest peekRequest() {
        if (this.directRequest != null) {
            SpeakRequest result = this.directRequest;
            this.directRequest = null;
            return result;
        }
        return this.queue.peekFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void readQueue() {
        while (true) {
            try {
                while (true) lbl-1000:
                // 7 sources

                {
                    this.lock.lock();
                    try {
                        Debugging.println("tts", "Waiting for message", new Object[0]);
                        while ((message = this.peekRequest()) == null) {
                            this.queueNotEmpty.await();
                        }
                        Debugging.println("tts", "Reading: %s", new Object[]{message});
                    }
                    finally {
                        this.lock.unlock();
                    }
                    if (!this.isPaused.get()) {
                        this.currentlySpeaking.set(true);
                        this.speakInternal(message);
                        this.currentlySpeaking.set(false);
                        if (!this.speakingInterrupted.get()) {
                            this.lock.lock();
                            try {
                                if (message.mode == SpeakRequest.Mode.STOP_SAY_DIRECTLY || this.queue.isEmpty()) ** GOTO lbl-1000
                                this.addDone(this.queue.removeFirst());
                                Debugging.println("tts", "Moved to done queue", new Object[0]);
                            }
                            finally {
                                this.lock.unlock();
                            }
                            continue;
                        }
                        this.speakingInterrupted.set(false);
                        continue;
                    }
                    this.lock.lock();
                    try {
                        while (this.isPaused.get()) {
                            Debugging.println("tts", "Paused, waiting", new Object[0]);
                            this.unpaused.await();
                        }
                        Debugging.println("tts", "Unpaused, continue", new Object[0]);
                    }
                    finally {
                        this.lock.unlock();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                continue;
            }
            ** GOTO lbl-1000
            break;
        }
    }

    public void start() {
        if (!this.checkProvider()) {
            return;
        }
        if (!this.settings.getBoolean("ttsEnabled")) {
            this.playSound(SOUND_ERROR);
            return;
        }
        this.playSound(SOUND_UNMUTE);
        this.startInternal();
    }

    private void startInternal() {
        this.lock.lock();
        try {
            this.isPaused.set(false);
            this.unpaused.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void pause() {
        if (!this.checkProvider()) {
            return;
        }
        this.pauseInternal();
        this.playSound(SOUND_MUTE);
    }

    private void pauseInternal() {
        this.isPaused.set(true);
        this.interruptSpeaking();
        LOGGER.info("TTS stopped");
    }

    private void interruptSpeaking() {
        if (this.currentlySpeaking.get()) {
            this.speakingInterrupted.set(true);
        }
        this.ttsProvider.stop();
    }

    public void enable() {
        if (!this.checkProvider()) {
            return;
        }
        this.playSound(SOUND_ON);
        this.settings.setBoolean("ttsEnabled", true);
        this.startInternal();
    }

    public void disable() {
        if (!this.checkProvider()) {
            return;
        }
        this.playSound(SOUND_OFF);
        this.settings.setBoolean("ttsEnabled", false);
        this.pauseInternal();
        this.clearQueueInternal();
    }

    public void clearQueue() {
        if (!this.checkProvider()) {
            return;
        }
        this.playSound(SOUND_CLEARQUEUE);
        this.clearQueueInternal();
    }

    public void clearQueueInternal() {
        this.lock.lock();
        try {
            this.queue.clear();
            this.doneQueue.clear();
        }
        finally {
            this.lock.unlock();
        }
        this.interruptSpeaking();
    }

    public void markQueueAsDone() {
        if (!this.checkProvider()) {
            return;
        }
        this.lock.lock();
        try {
            SpeakRequest request;
            while ((request = this.queue.pollFirst()) != null) {
                this.addDone(request);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void addDone(SpeakRequest request) {
        assert (this.lock.isHeldByCurrentThread());
        this.doneQueue.addFirst(request);
        if (this.doneQueue.size() > 100) {
            this.doneQueue.pollLast();
        }
    }

    private int getSize(LinkedList queue) {
        this.lock.lock();
        try {
            int n = queue.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void skipForwards() {
        if (!this.checkProvider()) {
            return;
        }
        if (this.getSize(this.queue) < (this.isPaused.get() ? 1 : 2)) {
            this.playSound(SOUND_ERROR);
        }
        if (this.isPaused.get()) {
            this.start();
        } else {
            this.ttsProvider.stop();
        }
    }

    public void skipBackwards() {
        if (!this.checkProvider()) {
            return;
        }
        if (this.getSize(this.doneQueue) < 1) {
            this.playSound(SOUND_ERROR);
            return;
        }
        this.lock.lock();
        try {
            SpeakRequest prevMessage = this.doneQueue.pollFirst();
            if (prevMessage != null) {
                this.queue.addFirst(prevMessage);
                this.queueNotEmpty.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.isPaused.get()) {
            this.start();
        } else {
            this.interruptSpeaking();
        }
    }

    public void shutdown() {
        this.shutdown.set(true);
        this.pauseInternal();
        this.clearQueueInternal();
        LOGGER.info("TTS shutdown complete");
    }

    public List<VoiceInfo> getAvailableVoices() {
        return this.ttsProvider.getAvailableVoices();
    }

    public String getProviderId() {
        return this.ttsProvider.getProviderId();
    }

    public static void main(String[] args) throws ExecutionException {
        Settings settings = new Settings("", null);
        settings.addBoolean("ttsEnabled", true);
        settings.addLong("ttsMaxLength", 2000L);
        settings.addLong("ttsRate", 100L);
        settings.addLong("ttsVolume", 100L);
        settings.addLong("ttsPitch", 0L);
        settings.addMap("ttsVoice", new HashMap(), 1);
        TextToSpeech speech = new TextToSpeech(settings);
        speech.getSize(new LinkedList());
        System.out.println("after");
    }

    private void playSound(String filename) {
        if (this.shutdown.get()) {
            return;
        }
        try {
            long volume = this.settings.getLong("ttsHotkeysVolume");
            if (volume > 0L) {
                Sound.play(TextToSpeech.class.getResource(filename), (float)volume, "TTS" + filename, 0);
            }
        }
        catch (Exception ex) {
            LOGGER.warning("Error playing sound: " + ex);
        }
    }
}

