/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.tts;

import chatty.util.Debugging;
import chatty.util.tts.SpeakRequest;
import chatty.util.tts.TTSProvider;
import chatty.util.tts.VoiceInfo;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Logger;

public class WindowsTTSProvider
implements TTSProvider {
    private static final Logger LOGGER = Logger.getLogger(WindowsTTSProvider.class.getName());
    private volatile Process process;
    private volatile boolean forceStopped;

    private String escapeXml(String text) {
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;");
    }

    @Override
    public void speak(SpeakRequest request) throws Exception {
        int ssmlRate = request.rate;
        String ssmlPitch = String.format("%+d%%", request.pitch);
        String voice = request.voice;
        if (voice == null || voice.isEmpty()) {
            voice = "default";
        }
        String escapedText = this.escapeXml(request.text);
        String ssml = String.format("<speak version='1.0' xmlns='http://www.w3.org/2001/10/synthesis' xml:lang='en-US'><voice name='%s'><prosody rate='%d%%' volume='%d' pitch='%s'>%s</prosody></voice></speak>", voice, ssmlRate, request.volume, ssmlPitch, escapedText);
        Debugging.println("tts", ssml, new Object[0]);
        String script = "Add-Type -AssemblyName System.Speech; $speak = New-Object System.Speech.Synthesis.SpeechSynthesizer; $speak.SpeakSsml($env:tts_ssml); $speak.Dispose();";
        ProcessBuilder pb = new ProcessBuilder("powershell", "-Command", script);
        pb.environment().put("tts_ssml", ssml);
        this.forceStopped = false;
        this.process = pb.start();
        this.process.waitFor();
        if (this.process.exitValue() != 0 && !this.forceStopped) {
            InputStream errorStream = this.process.getErrorStream();
            String error = new Scanner(errorStream).useDelimiter("\\\\A").next();
            LOGGER.warning("PowerShell TTS error: " + error);
            throw new Exception("PowerShell TTS failed with exit code: " + this.process.exitValue() + ", error: " + error);
        }
    }

    @Override
    public void stop() {
        if (this.process != null) {
            this.forceStopped = true;
            this.process.destroy();
        }
    }

    @Override
    public String getProviderId() {
        return "WinSpeech";
    }

    @Override
    public List<VoiceInfo> getAvailableVoices() {
        ArrayList<VoiceInfo> voices = new ArrayList<VoiceInfo>();
        voices.add(new VoiceInfo("Default", null, null));
        try {
            String line;
            String script = "Add-Type -AssemblyName System.Speech; $speak = New-Object System.Speech.Synthesis.SpeechSynthesizer; $speak.GetInstalledVoices() | ForEach-Object { $_.VoiceInfo.Name + '|' + $_.VoiceInfo.Gender + '|' + $_.VoiceInfo.Culture.Name }; $speak.Dispose();";
            ProcessBuilder pb = new ProcessBuilder("powershell", "-Command", script);
            Process process = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                String[] parts = line.trim().split("\\|");
                String name = parts.length > 0 ? parts[0] : null;
                String gender = parts.length > 1 ? parts[1] : null;
                String locale = parts.length > 2 ? parts[2] : null;
                voices.add(new VoiceInfo(name, gender, locale));
            }
            process.waitFor();
        }
        catch (Exception e) {
            LOGGER.warning("Failed to get Windows voices: " + e.getMessage());
        }
        return voices;
    }
}

