/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.txtmark.cmd;

import com.github.rjeschke.txtmark.Configuration;
import com.github.rjeschke.txtmark.Processor;
import com.github.rjeschke.txtmark.cmd.CmdLineParser;
import com.github.rjeschke.txtmark.cmd.CodeBlockEmitter;
import com.github.rjeschke.txtmark.cmd.TxtmarkArguments;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public final class Run {
    private static final void printUsage() {
        try {
            System.out.println("Usage: txtmark [options] [input-file]");
            System.out.println("Options:");
            System.out.println(CmdLineParser.generateHelp(80, false, new TxtmarkArguments()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        TxtmarkArguments ta = new TxtmarkArguments();
        List<Object> rest = new ArrayList();
        boolean parseError = false;
        try {
            rest = CmdLineParser.parse(args, ta);
        }
        catch (IOException e) {
            System.out.println("Error: " + e.getMessage());
            System.out.println("---");
            parseError = true;
        }
        if (ta.printHelp || parseError) {
            Run.printUsage();
            System.exit(parseError ? 1 : 0);
        }
        Configuration.Builder cfgBuilder = Configuration.builder();
        cfgBuilder.setEncoding(ta.encoding).setEnablePanicMode(ta.panicMode).setSafeMode(ta.safeMode).setAllowSpacesInFencedCodeBlockDelimiters(!ta.noFencedSpaced);
        if (ta.forceExtendedProfile) {
            cfgBuilder.forceExtentedProfile();
        }
        if (ta.highlighter != null && !ta.highlighter.isEmpty()) {
            if (!new File(ta.highlighter).exists()) {
                System.err.println("Program '" + ta.highlighter + "' not found");
                System.exit(1);
            }
            cfgBuilder.setCodeBlockEmitter(new CodeBlockEmitter(ta.encoding, ta.highlighter));
        }
        Configuration config = cfgBuilder.build();
        boolean processOk = true;
        InputStream input = null;
        Writer output = null;
        try {
            String inFile = rest.isEmpty() ? "--" : (String)rest.get(0);
            String outFile = ta.outFile;
            input = inFile.equals("--") ? System.in : new FileInputStream(inFile);
            String result = Processor.process(input, config);
            output = outFile == null ? new OutputStreamWriter((OutputStream)System.out, ta.encoding) : new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), ta.encoding);
            output.write(result);
        }
        catch (IOException e) {
            processOk = false;
            System.err.println("Exception: " + e.toString());
            e.printStackTrace(System.err);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
        System.exit(processOk ? 0 : 1);
    }
}

