/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.acryl;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import javax.swing.JRootPane;

public class AcrylTitlePane
extends BaseTitlePane {
    public AcrylTitlePane(JRootPane root, BaseRootPaneUI ui) {
        super(root, ui);
    }

    @Override
    public LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    @Override
    protected int getHorSpacing() {
        return 1;
    }

    @Override
    protected int getVerSpacing() {
        return 3;
    }

    @Override
    public void paintBorder(Graphics g) {
        if (this.isActive()) {
            g.setColor(AbstractLookAndFeel.getWindowBorderColor());
        } else {
            g.setColor(AbstractLookAndFeel.getWindowInactiveBorderColor());
        }
        g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    @Override
    public void paintText(Graphics g, int x, int y, String title) {
        Color shadowColor = AbstractLookAndFeel.getWindowTitleColorDark();
        if (this.isActive()) {
            shadowColor = ColorHelper.darker(shadowColor, 30.0);
        }
        g.setColor(shadowColor);
        JTattooUtilities.drawString(this.rootPane, g, title, x - 1, y - 1);
        JTattooUtilities.drawString(this.rootPane, g, title, x - 1, y + 1);
        JTattooUtilities.drawString(this.rootPane, g, title, x + 1, y - 1);
        JTattooUtilities.drawString(this.rootPane, g, title, x + 1, y + 1);
        if (this.isActive()) {
            g.setColor(AbstractLookAndFeel.getWindowTitleForegroundColor());
        } else {
            g.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
        }
        JTattooUtilities.drawString(this.rootPane, g, title, x, y);
    }

    static /* synthetic */ int access$2300(AcrylTitlePane x0) {
        return x0.buttonsWidth;
    }

    static /* synthetic */ int access$4000(AcrylTitlePane x0) {
        return x0.buttonsWidth;
    }

    protected class TitlePaneLayout
    implements LayoutManager {
        protected TitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int height = this.computeHeight();
            return new Dimension(height, height);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        protected int computeHeight() {
            FontMetrics fm = JTattooUtilities.getFontMetrics(AcrylTitlePane.this, null, AcrylTitlePane.this.getFont());
            return fm.getHeight() + 5;
        }

        @Override
        public void layoutContainer(Container c) {
            if (AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn()) {
                this.layoutMacStyle(c);
            } else {
                this.layoutDefault(c);
            }
        }

        public void layoutDefault(Container c) {
            boolean leftToRight = AcrylTitlePane.this.isLeftToRight();
            int spacing = AcrylTitlePane.this.getHorSpacing();
            int w = AcrylTitlePane.this.getWidth();
            int h = AcrylTitlePane.this.getHeight();
            int btnHeight = h - AcrylTitlePane.this.getVerSpacing();
            int btnWidth = btnHeight + 10;
            if (AcrylTitlePane.this.menuBar != null) {
                int mw = ((AcrylTitlePane)AcrylTitlePane.this).menuBar.getPreferredSize().width;
                int mh = ((AcrylTitlePane)AcrylTitlePane.this).menuBar.getPreferredSize().height;
                if (leftToRight) {
                    AcrylTitlePane.this.menuBar.setBounds(2, (h - mh) / 2, mw, mh);
                } else {
                    AcrylTitlePane.this.menuBar.setBounds(AcrylTitlePane.this.getWidth() - mw, (h - mh) / 2, mw, mh);
                }
            }
            int x = leftToRight ? w - spacing : 0;
            int y = Math.max(0, (h - btnHeight) / 2 - 1);
            if (AcrylTitlePane.this.closeButton != null) {
                AcrylTitlePane.this.closeButton.setBounds(x += leftToRight ? -btnWidth : spacing, y, btnWidth, btnHeight);
                if (!leftToRight) {
                    x += btnWidth;
                }
            }
            if (AcrylTitlePane.this.maxButton != null && AcrylTitlePane.this.maxButton.getParent() != null && Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
                AcrylTitlePane.this.maxButton.setBounds(x += leftToRight ? -spacing - btnWidth : spacing, y, btnWidth, btnHeight);
                if (!leftToRight) {
                    x += btnWidth;
                }
            }
            if (AcrylTitlePane.this.iconifyButton != null && AcrylTitlePane.this.iconifyButton.getParent() != null) {
                AcrylTitlePane.this.iconifyButton.setBounds(x += leftToRight ? -spacing - btnWidth : spacing, y, btnWidth, btnHeight);
                if (!leftToRight) {
                    x += btnWidth;
                }
            }
            AcrylTitlePane.this.buttonsWidth = leftToRight ? w - x : x;
            if (AcrylTitlePane.this.customTitlePanel != null) {
                int maxWidth = w - AcrylTitlePane.this.buttonsWidth - spacing - 20;
                if (AcrylTitlePane.this.menuBar != null) {
                    maxWidth -= ((AcrylTitlePane)AcrylTitlePane.this).menuBar.getPreferredSize().width;
                    maxWidth -= spacing;
                }
                int cpw = Math.min(maxWidth, ((AcrylTitlePane)AcrylTitlePane.this).customTitlePanel.getPreferredSize().width);
                int cph = h;
                int cpx = leftToRight ? w - AcrylTitlePane.this.buttonsWidth - cpw : AcrylTitlePane.this.buttonsWidth;
                int cpy = 0;
                AcrylTitlePane.this.customTitlePanel.setBounds(cpx, cpy, cpw, cph);
                AcrylTitlePane.this.buttonsWidth = AcrylTitlePane.this.buttonsWidth + ((AcrylTitlePane)AcrylTitlePane.this).customTitlePanel.getPreferredSize().width;
            }
        }

        private void layoutMacStyle(Container c) {
            int btnHeight;
            int spacing = AcrylTitlePane.this.getHorSpacing();
            int h = AcrylTitlePane.this.getHeight();
            int btnWidth = btnHeight = h - AcrylTitlePane.this.getVerSpacing();
            int x = 0;
            int y = 0;
            if (AcrylTitlePane.this.closeButton != null) {
                AcrylTitlePane.this.closeButton.setBounds(x, y, btnWidth, btnHeight);
                x += btnWidth + spacing;
            }
            if (AcrylTitlePane.this.iconifyButton != null && AcrylTitlePane.this.iconifyButton.getParent() != null) {
                AcrylTitlePane.this.iconifyButton.setBounds(x, y, btnWidth, btnHeight);
                x += btnWidth + spacing;
            }
            if (AcrylTitlePane.this.maxButton != null && AcrylTitlePane.this.maxButton.getParent() != null && Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
                AcrylTitlePane.this.maxButton.setBounds(x, y, btnWidth, btnHeight);
                x += btnWidth + spacing;
            }
            AcrylTitlePane.this.buttonsWidth = x;
            if (AcrylTitlePane.this.customTitlePanel != null) {
                int cpx = AcrylTitlePane.this.buttonsWidth + 5;
                int cpy = 0;
                int cpw = ((AcrylTitlePane)AcrylTitlePane.this).customTitlePanel.getPreferredSize().width;
                int cph = h;
                AcrylTitlePane.this.customTitlePanel.setBounds(cpx, cpy, cpw, cph);
                AcrylTitlePane.this.buttonsWidth = AcrylTitlePane.this.buttonsWidth + (cpw + 5);
            }
        }
    }
}

