/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.hifi;

import com.jtattoo.plaf.AbstractTheme;
import com.jtattoo.plaf.ColorHelper;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

public class HiFiDefaultTheme
extends AbstractTheme {
    public HiFiDefaultTheme() {
        this.setUpColor();
        this.loadProperties();
        this.setUpColorArrs();
    }

    @Override
    public String getPropertyFileName() {
        return "HiFiTheme.properties";
    }

    @Override
    public void setUpColor() {
        super.setUpColor();
        textShadow = true;
        foregroundColor = EXTRA_LIGHT_GRAY;
        disabledForegroundColor = GRAY;
        disabledBackgroundColor = new ColorUIResource(48, 48, 48);
        backgroundColor = new ColorUIResource(48, 48, 48);
        backgroundColorLight = new ColorUIResource(48, 48, 48);
        backgroundColorDark = new ColorUIResource(16, 16, 16);
        alterBackgroundColor = new ColorUIResource(64, 64, 64);
        selectionForegroundColor = WHITE;
        selectionBackgroundColor = new ColorUIResource(40, 40, 40);
        selectionBackgroundColorLight = WHITE;
        selectionBackgroundColorDark = BLACK;
        frameColor = BLACK;
        gridColor = BLACK;
        focusCellColor = ORANGE;
        inputBackgroundColor = new ColorUIResource(80, 80, 80);
        inputForegroundColor = foregroundColor;
        rolloverForegroundColor = EXTRA_LIGHT_GRAY;
        rolloverColor = new ColorUIResource(112, 112, 112);
        rolloverColorLight = WHITE;
        rolloverColorDark = BLACK;
        pressedForegroundColor = WHITE;
        pressedBackgroundColor = new ColorUIResource(24, 24, 24);
        pressedBackgroundColorLight = new ColorUIResource(ColorHelper.brighter(pressedBackgroundColor, 4.0));
        pressedBackgroundColorDark = new ColorUIResource(ColorHelper.darker(pressedBackgroundColor, 40.0));
        buttonForegroundColor = foregroundColor;
        buttonBackgroundColor = new ColorUIResource(96, 96, 96);
        buttonColorLight = new ColorUIResource(96, 96, 96);
        buttonColorDark = new ColorUIResource(32, 32, 32);
        controlForegroundColor = foregroundColor;
        controlBackgroundColor = new ColorUIResource(64, 64, 64);
        controlColorLight = new ColorUIResource(96, 96, 96);
        controlColorDark = new ColorUIResource(32, 32, 32);
        inactiveColorLight = new ColorUIResource(64, 64, 64);
        inactiveColorDark = new ColorUIResource(32, 32, 32);
        controlHighlightColor = new ColorUIResource(96, 96, 96);
        controlShadowColor = new ColorUIResource(32, 32, 32);
        controlDarkShadowColor = BLACK;
        windowTitleForegroundColor = foregroundColor;
        windowTitleBackgroundColor = new ColorUIResource(32, 32, 32);
        windowTitleColorLight = new ColorUIResource(96, 96, 96);
        windowTitleColorDark = new ColorUIResource(32, 32, 32);
        windowBorderColor = BLACK;
        windowIconColor = LIGHT_GRAY;
        windowIconShadowColor = BLACK;
        windowIconRolloverColor = ORANGE;
        windowInactiveTitleForegroundColor = new ColorUIResource(196, 196, 196);
        windowInactiveTitleBackgroundColor = new ColorUIResource(64, 64, 64);
        windowInactiveTitleColorLight = new ColorUIResource(64, 64, 64);
        windowInactiveTitleColorDark = new ColorUIResource(32, 32, 32);
        windowInactiveBorderColor = BLACK;
        menuForegroundColor = foregroundColor;
        menuBackgroundColor = new ColorUIResource(32, 32, 32);
        menuSelectionForegroundColor = WHITE;
        menuSelectionBackgroundColor = new ColorUIResource(96, 96, 96);
        menuColorLight = new ColorUIResource(96, 96, 96);
        menuColorDark = new ColorUIResource(32, 32, 32);
        toolbarBackgroundColor = new ColorUIResource(48, 48, 48);
        toolbarColorLight = new ColorUIResource(96, 96, 96);
        toolbarColorDark = new ColorUIResource(32, 32, 32);
        tabAreaBackgroundColor = backgroundColor;
        tabSelectionForegroundColor = selectionForegroundColor;
        desktopColor = new ColorUIResource(64, 64, 64);
        tooltipForegroundColor = WHITE;
        tooltipBackgroundColor = new ColorUIResource(24, 24, 24);
        controlFont = new FontUIResource("Dialog", 1, 12);
        systemFont = new FontUIResource("Dialog", 1, 12);
        userFont = new FontUIResource("Dialog", 1, 12);
        menuFont = new FontUIResource("Dialog", 1, 12);
        windowTitleFont = new FontUIResource("Dialog", 1, 12);
        smallFont = new FontUIResource("Dialog", 0, 10);
    }

    @Override
    public void setUpColorArrs() {
        super.setUpColorArrs();
        if (rolloverColorLight == WHITE) {
            rolloverColorLight = new ColorUIResource(ColorHelper.brighter(controlColorLight, 15.0));
        }
        if (rolloverColorDark == BLACK) {
            rolloverColorDark = new ColorUIResource(ColorHelper.brighter(controlColorDark, 15.0));
        }
        if (selectionBackgroundColorLight == WHITE) {
            selectionBackgroundColorLight = new ColorUIResource(ColorHelper.brighter(controlColorLight, 15.0));
        }
        if (selectionBackgroundColorDark == BLACK) {
            selectionBackgroundColorDark = new ColorUIResource(ColorHelper.brighter(controlColorDark, 15.0));
        }
        if (pressedForegroundColor == WHITE) {
            pressedForegroundColor = foregroundColor;
        }
        DEFAULT_COLORS = ColorHelper.createColorArr(controlColorLight, controlColorDark, 20);
        HIDEFAULT_COLORS = ColorHelper.createColorArr(ColorHelper.brighter(controlColorLight, 15.0), ColorHelper.brighter(controlColorDark, 15.0), 20);
        ACTIVE_COLORS = DEFAULT_COLORS;
        INACTIVE_COLORS = ColorHelper.createColorArr(inactiveColorLight, inactiveColorDark, 20);
        SELECTED_COLORS = ColorHelper.createColorArr(selectionBackgroundColorLight, selectionBackgroundColorDark, 20);
        BUTTON_COLORS = ColorHelper.createColorArr(buttonColorLight, buttonColorDark, 20);
        ROLLOVER_COLORS = ColorHelper.createColorArr(rolloverColorLight, rolloverColorDark, 20);
        DISABLED_COLORS = ColorHelper.createColorArr(ColorHelper.brighter(controlColorDark, 5.0), ColorHelper.darker(controlColorDark, 10.0), 20);
        WINDOW_TITLE_COLORS = ColorHelper.createColorArr(windowTitleColorLight, windowTitleColorDark, 20);
        WINDOW_INACTIVE_TITLE_COLORS = ColorHelper.createColorArr(windowInactiveTitleColorLight, windowInactiveTitleColorDark, 20);
        MENUBAR_COLORS = DEFAULT_COLORS;
        TOOLBAR_COLORS = MENUBAR_COLORS;
        TRACK_COLORS = ColorHelper.createColorArr(ColorHelper.darker(backgroundColor, 10.0), ColorHelper.brighter(backgroundColor, 5.0), 20);
        SLIDER_COLORS = DEFAULT_COLORS;
        PROGRESSBAR_COLORS = DEFAULT_COLORS;
        THUMB_COLORS = DEFAULT_COLORS;
        TAB_COLORS = DEFAULT_COLORS;
        COL_HEADER_COLORS = DEFAULT_COLORS;
    }
}

