/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.hifi;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseTabbedPaneUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;

public class HiFiTabbedPaneUI
extends BaseTabbedPaneUI {
    public static ComponentUI createUI(JComponent c) {
        return new HiFiTabbedPaneUI();
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        switch (AbstractLookAndFeel.getTheme().getTabSeparatorStyle()) {
            case 2: {
                this.tabAreaInsets.bottom = 0;
                break;
            }
            case 3: {
                this.tabAreaInsets.bottom = 2;
                break;
            }
            case 4: 
            case 5: {
                this.tabAreaInsets.bottom = 4;
                break;
            }
            default: {
                this.tabAreaInsets.bottom = 5;
            }
        }
    }

    @Override
    protected Color[] getContentBorderColors(int tabPlacement) {
        ColorUIResource selColor = AbstractLookAndFeel.getTheme().getSelectionBackgroundColorDark();
        ColorUIResource bgColor = AbstractLookAndFeel.getBackgroundColor();
        switch (AbstractLookAndFeel.getTheme().getTabSeparatorStyle()) {
            case 1: {
                return new Color[]{ColorHelper.darker(AbstractLookAndFeel.getBackgroundColor(), 40.0), ColorHelper.brighter(AbstractLookAndFeel.getBackgroundColor(), 10.0), ColorHelper.darker(AbstractLookAndFeel.getBackgroundColor(), 20.0), ColorHelper.darker(AbstractLookAndFeel.getBackgroundColor(), 40.0), ColorHelper.darker(AbstractLookAndFeel.getBackgroundColor(), 60.0)};
            }
            case 3: {
                return new Color[]{ColorHelper.darker(AbstractLookAndFeel.getBackgroundColor(), 40.0), ColorHelper.darker(AbstractLookAndFeel.getBackgroundColor(), 40.0)};
            }
            case 4: {
                return new Color[]{ColorHelper.darker(AbstractLookAndFeel.getBackgroundColor(), 40.0), ColorHelper.darker(AbstractLookAndFeel.getBackgroundColor(), 10.0), ColorHelper.darker(AbstractLookAndFeel.getBackgroundColor(), 30.0), ColorHelper.darker(AbstractLookAndFeel.getBackgroundColor(), 50.0)};
            }
            case 5: {
                return new Color[]{ColorHelper.darker(selColor, 50.0), ColorHelper.darker(selColor, 0.0), ColorHelper.darker(selColor, 30.0), ColorHelper.darker(selColor, 60.0)};
            }
            case 6: {
                return new Color[]{ColorHelper.darker(selColor, 50.0), ColorHelper.darker(selColor, 0.0), ColorHelper.darker(selColor, 20.0), ColorHelper.darker(selColor, 40.0), ColorHelper.darker(selColor, 60.0)};
            }
            case 7: {
                return new Color[]{ColorHelper.darker(ColorHelper.median(bgColor, selColor), 50.0), ColorHelper.darker(ColorHelper.median(bgColor, selColor), 0.0), ColorHelper.darker(ColorHelper.median(bgColor, selColor), 20.0), ColorHelper.darker(ColorHelper.median(bgColor, selColor), 40.0), ColorHelper.darker(ColorHelper.median(bgColor, selColor), 60.0)};
            }
            case 8: {
                return new Color[]{ColorHelper.darker(ColorHelper.median(bgColor, selColor), 50.0), ColorHelper.darker(ColorHelper.median(bgColor, selColor), 0.0), ColorHelper.darker(ColorHelper.median(bgColor, selColor), 5.0), ColorHelper.darker(ColorHelper.median(bgColor, selColor), 20.0), ColorHelper.darker(ColorHelper.median(bgColor, selColor), 60.0)};
            }
        }
        return new Color[]{ColorHelper.darker(AbstractLookAndFeel.getBackgroundColor(), 40.0), ColorHelper.brighter(AbstractLookAndFeel.getBackgroundColor(), 20.0), ColorHelper.darker(AbstractLookAndFeel.getBackgroundColor(), 20.0), ColorHelper.darker(AbstractLookAndFeel.getBackgroundColor(), 40.0), ColorHelper.darker(AbstractLookAndFeel.getBackgroundColor(), 60.0)};
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        Color backColor = this.tabPane.getBackgroundAt(tabIndex);
        if (!(backColor instanceof UIResource)) {
            super.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
            return;
        }
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            Graphics2D g2D = (Graphics2D)g;
            Object savedRenderingHint = null;
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
            }
            v.paint(g, textRect);
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedRenderingHint);
            }
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            Graphics2D g2D = (Graphics2D)g;
            Color fc = this.tabPane.getForegroundAt(tabIndex);
            if (isSelected) {
                fc = AbstractLookAndFeel.getTheme().getTabSelectionForegroundColor();
            }
            if (!this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(tabIndex)) {
                fc = AbstractLookAndFeel.getTheme().getDisabledForegroundColor();
            }
            if (ColorHelper.getGrayValue(fc) > 128) {
                g2D.setColor(Color.black);
            } else {
                g2D.setColor(Color.white);
            }
            if (AbstractLookAndFeel.getTheme().isTextShadowOn()) {
                Composite savedComposite = g2D.getComposite();
                AlphaComposite alpha = AlphaComposite.getInstance(3, 0.6f);
                g2D.setComposite(alpha);
                JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x + 1, textRect.y + 1 + metrics.getAscent());
                g2D.setComposite(savedComposite);
            }
            g2D.setColor(fc);
            JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
        }
    }
}

