/*
 * Decompiled with CFR 0.152.
 */
package com.pngencoder;

import com.pngencoder.PngEncoderCountingOutputStream;
import com.pngencoder.PngEncoderDeflaterOutputStream;
import com.pngencoder.PngEncoderIdatChunksOutputStream;
import com.pngencoder.PngEncoderPhysicalPixelDimensions;
import com.pngencoder.PngEncoderScanlineUtil;
import com.pngencoder.PngEncoderSrgbRenderingIntent;
import com.pngencoder.PngEncoderVerificationUtil;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

class PngEncoderLogic {
    static final byte[] FILE_BEGINNING = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    static final byte[] FILE_ENDING = new byte[]{0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
    static final byte IHDR_BIT_DEPTH = 8;
    static final byte IHDR_COLOR_TYPE_RGB = 2;
    static final byte IHDR_COLOR_TYPE_RGBA = 6;
    static final byte IHDR_COMPRESSION_METHOD = 0;
    static final byte IHDR_FILTER_METHOD = 0;
    static final byte IHDR_INTERLACE_METHOD = 0;
    public static final byte[] GAMA_SRGB_VALUE = ByteBuffer.allocate(4).putInt(45455).array();
    public static final byte[] CHRM_SRGB_VALUE = ByteBuffer.allocate(32).putInt(31270).putInt(32900).putInt(64000).putInt(33000).putInt(30000).putInt(60000).putInt(15000).putInt(6000).array();

    private PngEncoderLogic() {
    }

    static int encode(BufferedImage bufferedImage, OutputStream outputStream, int compressionLevel, boolean multiThreadedCompressionEnabled, PngEncoderSrgbRenderingIntent srgbRenderingIntent, PngEncoderPhysicalPixelDimensions physicalPixelDimensions) throws IOException {
        int segmentMaxLengthOriginal;
        Objects.requireNonNull(bufferedImage, "bufferedImage");
        Objects.requireNonNull(outputStream, "outputStream");
        boolean alpha = bufferedImage.getTransparency() != 1;
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        PngEncoderCountingOutputStream countingOutputStream = new PngEncoderCountingOutputStream(outputStream);
        countingOutputStream.write(FILE_BEGINNING);
        byte[] ihdr = PngEncoderLogic.getIhdrHeader(width, height, alpha);
        byte[] ihdrChunk = PngEncoderLogic.asChunk("IHDR", ihdr);
        countingOutputStream.write(ihdrChunk);
        if (srgbRenderingIntent != null) {
            outputStream.write(PngEncoderLogic.asChunk("sRGB", new byte[]{srgbRenderingIntent.getValue()}));
            outputStream.write(PngEncoderLogic.asChunk("gAMA", GAMA_SRGB_VALUE));
            outputStream.write(PngEncoderLogic.asChunk("cHRM", CHRM_SRGB_VALUE));
        }
        if (physicalPixelDimensions != null) {
            outputStream.write(PngEncoderLogic.asChunk("pHYs", PngEncoderLogic.getPhysicalPixelDimensions(physicalPixelDimensions)));
        }
        PngEncoderIdatChunksOutputStream idatChunksOutputStream = new PngEncoderIdatChunksOutputStream(countingOutputStream);
        byte[] scanlineBytes = PngEncoderScanlineUtil.get(bufferedImage);
        if (scanlineBytes.length <= (segmentMaxLengthOriginal = PngEncoderDeflaterOutputStream.getSegmentMaxLengthOriginal(scanlineBytes.length)) || !multiThreadedCompressionEnabled) {
            Deflater deflater = new Deflater(compressionLevel);
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)idatChunksOutputStream, deflater);
            deflaterOutputStream.write(scanlineBytes);
            deflaterOutputStream.finish();
            deflaterOutputStream.flush();
        } else {
            PngEncoderDeflaterOutputStream deflaterOutputStream = new PngEncoderDeflaterOutputStream(idatChunksOutputStream, compressionLevel, segmentMaxLengthOriginal);
            deflaterOutputStream.write(scanlineBytes);
            deflaterOutputStream.finish();
        }
        countingOutputStream.write(FILE_ENDING);
        countingOutputStream.flush();
        return countingOutputStream.getCount();
    }

    static byte[] getIhdrHeader(int width, int height, boolean alpha) {
        ByteBuffer buffer = ByteBuffer.allocate(13);
        buffer.putInt(width);
        buffer.putInt(height);
        buffer.put((byte)8);
        buffer.put(alpha ? (byte)6 : 2);
        buffer.put((byte)0);
        buffer.put((byte)0);
        buffer.put((byte)0);
        return buffer.array();
    }

    static byte[] getPhysicalPixelDimensions(PngEncoderPhysicalPixelDimensions physicalPixelDimensions) {
        ByteBuffer buffer = ByteBuffer.allocate(9);
        buffer.putInt(physicalPixelDimensions.getPixelsPerUnitX());
        buffer.putInt(physicalPixelDimensions.getPixelsPerUnitY());
        buffer.put(physicalPixelDimensions.getUnit().getValue());
        return buffer.array();
    }

    static byte[] asChunk(String type, byte[] data) {
        PngEncoderVerificationUtil.verifyChunkType(type);
        ByteBuffer byteBuffer = ByteBuffer.allocate(data.length + 12);
        byteBuffer.putInt(data.length);
        ByteBuffer byteBufferForCrc = byteBuffer.slice().asReadOnlyBuffer();
        byteBufferForCrc.limit(4 + data.length);
        byteBuffer.put(type.getBytes(StandardCharsets.US_ASCII));
        byteBuffer.put(data);
        byteBuffer.putInt(PngEncoderLogic.getCrc32(byteBufferForCrc));
        return byteBuffer.array();
    }

    static int getCrc32(ByteBuffer byteBuffer) {
        CRC32 crc = new CRC32();
        crc.update(byteBuffer);
        return (int)crc.getValue();
    }
}

