/*
 * Decompiled with CFR 0.152.
 */
package com.pngencoder;

import com.pngencoder.PngEncoderBufferedImageType;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;

class PngEncoderScanlineUtil {
    private PngEncoderScanlineUtil() {
    }

    static byte[] get(BufferedImage bufferedImage) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        PngEncoderBufferedImageType type = PngEncoderBufferedImageType.valueOf(bufferedImage);
        if (type == PngEncoderBufferedImageType.TYPE_INT_RGB) {
            int[] elements = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            return PngEncoderScanlineUtil.getIntRgb(elements, width, height);
        }
        if (type == PngEncoderBufferedImageType.TYPE_INT_ARGB) {
            int[] elements = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            return PngEncoderScanlineUtil.getIntArgb(elements, width, height);
        }
        if (type == PngEncoderBufferedImageType.TYPE_INT_BGR) {
            int[] elements = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            return PngEncoderScanlineUtil.getIntBgr(elements, width, height);
        }
        if (type == PngEncoderBufferedImageType.TYPE_3BYTE_BGR) {
            byte[] elements = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
            return PngEncoderScanlineUtil.get3ByteBgr(elements, width, height);
        }
        if (type == PngEncoderBufferedImageType.TYPE_4BYTE_ABGR) {
            byte[] elements = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
            return PngEncoderScanlineUtil.get4ByteAbgr(elements, width, height);
        }
        if (type == PngEncoderBufferedImageType.TYPE_BYTE_GRAY) {
            byte[] elements = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
            return PngEncoderScanlineUtil.getByteGray(elements, width, height);
        }
        if (type == PngEncoderBufferedImageType.TYPE_USHORT_GRAY) {
            short[] elements = ((DataBufferUShort)bufferedImage.getRaster().getDataBuffer()).getData();
            return PngEncoderScanlineUtil.getUshortGray(elements, width, height);
        }
        int[] elements = bufferedImage.getRGB(0, 0, width, height, null, 0, width);
        if (bufferedImage.getTransparency() == 1) {
            return PngEncoderScanlineUtil.getIntRgb(elements, width, height);
        }
        return PngEncoderScanlineUtil.getIntArgb(elements, width, height);
    }

    static byte[] getIntRgb(int[] elements, int width, int height) {
        int channels = 3;
        int rowByteSize = 1 + 3 * width;
        byte[] bytes = new byte[rowByteSize * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int element = elements[y * width + x];
                bytes[y * rowByteSize + x * 3 + 1] = (byte)(element >> 16);
                bytes[y * rowByteSize + x * 3 + 2] = (byte)(element >> 8);
                bytes[y * rowByteSize + x * 3 + 3] = (byte)element;
            }
        }
        return bytes;
    }

    static byte[] getIntArgb(int[] elements, int width, int height) {
        int channels = 4;
        int rowByteSize = 1 + 4 * width;
        byte[] bytes = new byte[rowByteSize * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int element = elements[y * width + x];
                bytes[y * rowByteSize + x * 4 + 1] = (byte)(element >> 16);
                bytes[y * rowByteSize + x * 4 + 2] = (byte)(element >> 8);
                bytes[y * rowByteSize + x * 4 + 3] = (byte)element;
                bytes[y * rowByteSize + x * 4 + 4] = (byte)(element >> 24);
            }
        }
        return bytes;
    }

    static byte[] getIntBgr(int[] elements, int width, int height) {
        int channels = 3;
        int rowByteSize = 1 + 3 * width;
        byte[] bytes = new byte[rowByteSize * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int element = elements[y * width + x];
                bytes[y * rowByteSize + x * 3 + 1] = (byte)element;
                bytes[y * rowByteSize + x * 3 + 2] = (byte)(element >> 8);
                bytes[y * rowByteSize + x * 3 + 3] = (byte)(element >> 16);
            }
        }
        return bytes;
    }

    static byte[] get3ByteBgr(byte[] elements, int width, int height) {
        int channels = 3;
        int rowByteSize = 1 + 3 * width;
        byte[] bytes = new byte[rowByteSize * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                bytes[y * rowByteSize + x * 3 + 1] = elements[(y * width + x) * 3 + 2];
                bytes[y * rowByteSize + x * 3 + 2] = elements[(y * width + x) * 3 + 1];
                bytes[y * rowByteSize + x * 3 + 3] = elements[(y * width + x) * 3 + 0];
            }
        }
        return bytes;
    }

    static byte[] get4ByteAbgr(byte[] elements, int width, int height) {
        int channels = 4;
        int rowByteSize = 1 + 4 * width;
        byte[] bytes = new byte[rowByteSize * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                bytes[y * rowByteSize + x * 4 + 1] = elements[(y * width + x) * 4 + 3];
                bytes[y * rowByteSize + x * 4 + 2] = elements[(y * width + x) * 4 + 2];
                bytes[y * rowByteSize + x * 4 + 3] = elements[(y * width + x) * 4 + 1];
                bytes[y * rowByteSize + x * 4 + 4] = elements[(y * width + x) * 4];
            }
        }
        return bytes;
    }

    static byte[] getByteGray(byte[] elements, int width, int height) {
        int channels = 3;
        int rowByteSize = 1 + 3 * width;
        byte[] bytes = new byte[rowByteSize * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                bytes[y * rowByteSize + x * 3 + 1] = elements[y * width + x];
                bytes[y * rowByteSize + x * 3 + 2] = elements[y * width + x];
                bytes[y * rowByteSize + x * 3 + 3] = elements[y * width + x];
            }
        }
        return bytes;
    }

    static byte[] getUshortGray(short[] elements, int width, int height) {
        int channels = 3;
        int rowByteSize = 1 + 3 * width;
        byte[] bytes = new byte[rowByteSize * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                bytes[y * rowByteSize + x * 3 + 1] = (byte)(elements[y * width + x] >> 8);
                bytes[y * rowByteSize + x * 3 + 2] = (byte)(elements[y * width + x] >> 8);
                bytes[y * rowByteSize + x * 3 + 3] = (byte)(elements[y * width + x] >> 8);
            }
        }
        return bytes;
    }
}

