/*
 * Decompiled with CFR 0.152.
 */
package com.tulskiy.keymaster.osx;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import com.tulskiy.keymaster.common.HotKey;
import com.tulskiy.keymaster.common.HotKeyListener;
import com.tulskiy.keymaster.common.MediaKey;
import com.tulskiy.keymaster.common.Provider;
import com.tulskiy.keymaster.osx.Carbon;
import com.tulskiy.keymaster.osx.KeyMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarbonProvider
extends Provider {
    private static final Logger LOGGER = LoggerFactory.getLogger(CarbonProvider.class);
    private static final int kEventHotKeyPressed = 5;
    private static final int kEventClassKeyboard = CarbonProvider.OS_TYPE("keyb");
    private static final int typeEventHotKeyID = CarbonProvider.OS_TYPE("hkid");
    private static final int kEventParamDirectObject = CarbonProvider.OS_TYPE("----");
    private static int idSeq = 1;
    private Map<Integer, OSXHotKey> hotKeys = new HashMap<Integer, OSXHotKey>();
    private Queue<OSXHotKey> registerQueue = new LinkedList<OSXHotKey>();
    private final Object lock = new Object();
    private boolean listen = true;
    private boolean reset;
    private Carbon.EventHandlerProcPtr keyListener;
    private PointerByReference eventHandlerReference;
    public Thread thread;

    @Override
    public void init() {
        this.thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = CarbonProvider.this.lock;
                synchronized (object) {
                    LOGGER.info("Installing Event Handler");
                    CarbonProvider.this.eventHandlerReference = new PointerByReference();
                    CarbonProvider.this.keyListener = new EventHandler();
                    Carbon.EventTypeSpec[] eventTypes = (Carbon.EventTypeSpec[])new Carbon.EventTypeSpec().toArray(1);
                    eventTypes[0].eventClass = kEventClassKeyboard;
                    eventTypes[0].eventKind = 5;
                    int status = Carbon.Lib.InstallEventHandler(Carbon.Lib.GetEventDispatcherTarget(), CarbonProvider.this.keyListener, 1, eventTypes, null, CarbonProvider.this.eventHandlerReference);
                    if (status != 0) {
                        LOGGER.warn("Could not register Event Handler, error code: " + status);
                    }
                    if (CarbonProvider.this.eventHandlerReference.getValue() == null) {
                        LOGGER.warn("Event Handler reference is null");
                    }
                    while (CarbonProvider.this.listen || CarbonProvider.this.reset) {
                        if (CarbonProvider.this.reset) {
                            CarbonProvider.this.resetAll();
                            CarbonProvider.this.reset = false;
                            CarbonProvider.this.lock.notify();
                        }
                        while (!CarbonProvider.this.registerQueue.isEmpty()) {
                            OSXHotKey hotKey = (OSXHotKey)CarbonProvider.this.registerQueue.poll();
                            if (hotKey.isUnregister()) {
                                CarbonProvider.this.unregister(hotKey);
                                continue;
                            }
                            CarbonProvider.this.register(hotKey);
                        }
                        try {
                            if (!CarbonProvider.this.listen) continue;
                            CarbonProvider.this.lock.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                LOGGER.info("Exit Carbon global hotkey thread");
            }
        }, "JKeyMaster-Carbon");
        this.thread.start();
    }

    private void resetAll() {
        LOGGER.info("Resetting hotkeys");
        for (OSXHotKey hotKey : this.hotKeys.values()) {
            this.unregisterHotKey(hotKey);
        }
        this.hotKeys.clear();
    }

    private void register(OSXHotKey hotKey) {
        int id;
        KeyStroke keyCode = hotKey.keyStroke;
        Carbon.EventHotKeyID.ByValue hotKeyReference = new Carbon.EventHotKeyID.ByValue();
        hotKeyReference.id = id = idSeq++;
        hotKeyReference.signature = CarbonProvider.OS_TYPE("hk" + String.format("%02d", id));
        PointerByReference gMyHotKeyRef = new PointerByReference();
        int status = Carbon.Lib.RegisterEventHotKey(KeyMap.getKeyCode(keyCode), KeyMap.getModifier(keyCode), hotKeyReference, Carbon.Lib.GetEventDispatcherTarget(), 0, gMyHotKeyRef);
        if (status != 0) {
            LOGGER.warn("Could not register HotKey: " + keyCode + ". Error code: " + status);
            return;
        }
        if (gMyHotKeyRef.getValue() == null) {
            LOGGER.warn("HotKey returned null handler reference");
            return;
        }
        hotKey.handler = gMyHotKeyRef;
        LOGGER.info(String.format("Registered hotkey: %s [%d]", hotKey, id));
        this.hotKeys.put(id, hotKey);
    }

    private void unregister(OSXHotKey hotKey) {
        this.hotKeys.entrySet().removeIf(regHotKey -> {
            boolean matches = hotKey.hasSameTrigger((HotKey)regHotKey.getValue());
            if (matches) {
                this.unregisterHotKey((OSXHotKey)regHotKey.getValue());
            }
            return matches;
        });
    }

    private void unregisterHotKey(OSXHotKey hotKey) {
        int ret = Carbon.Lib.UnregisterEventHotKey(hotKey.handler.getValue());
        if (ret != 0) {
            LOGGER.warn("Could not unregister hotkey (" + hotKey + "). Error code: " + ret);
        } else {
            LOGGER.info("Unregistering hotkey: " + hotKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        LOGGER.info("Stopping now");
        if (this.isRunning()) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    this.listen = false;
                    this.lock.notify();
                }
                this.thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.eventHandlerReference.getValue() != null) {
            Carbon.Lib.RemoveEventHandler(this.eventHandlerReference.getValue());
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        if (this.isRunning()) {
            Object object = this.lock;
            synchronized (object) {
                this.reset = true;
                this.registerQueue.clear();
                this.lock.notify();
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.thread != null && this.thread.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(KeyStroke keyCode, HotKeyListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.registerQueue.add(new OSXHotKey(keyCode, listener));
            this.lock.notify();
        }
    }

    @Override
    public void register(MediaKey mediaKey, HotKeyListener listener) {
        LOGGER.warn("Media keys are not supported on this platform");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(KeyStroke keyCode) {
        Object object = this.lock;
        synchronized (object) {
            this.registerQueue.add(new OSXHotKey(keyCode, null));
            this.lock.notify();
        }
    }

    @Override
    public void unregister(MediaKey mediaKey) {
        LOGGER.warn("Media keys are not supported on this platform");
    }

    private static int OS_TYPE(String osType) {
        byte[] bytes = osType.getBytes();
        return (bytes[0] << 24) + (bytes[1] << 16) + (bytes[2] << 8) + bytes[3];
    }

    class OSXHotKey
    extends HotKey {
        PointerByReference handler;

        public OSXHotKey(KeyStroke keyStroke, HotKeyListener listener) {
            super(keyStroke, listener);
        }
    }

    private class EventHandler
    implements Carbon.EventHandlerProcPtr {
        private EventHandler() {
        }

        @Override
        public int callback(Pointer inHandlerCallRef, Pointer inEvent, Pointer inUserData) {
            Carbon.EventHotKeyID eventHotKeyID = new Carbon.EventHotKeyID();
            int ret = Carbon.Lib.GetEventParameter(inEvent, kEventParamDirectObject, typeEventHotKeyID, null, eventHotKeyID.size(), null, eventHotKeyID);
            if (ret != 0) {
                LOGGER.warn("Could not get event parameters. Error code: " + ret);
            } else {
                int eventId = eventHotKeyID.id;
                LOGGER.info("Received event id: " + eventId);
                CarbonProvider.this.fireEvent((HotKey)CarbonProvider.this.hotKeys.get(eventId));
            }
            return 0;
        }
    }
}

