/*
 * Decompiled with CFR 0.152.
 */
package com.tulskiy.keymaster.windows;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinUser;
import com.tulskiy.keymaster.common.HotKey;
import com.tulskiy.keymaster.common.HotKeyListener;
import com.tulskiy.keymaster.common.MediaKey;
import com.tulskiy.keymaster.common.Provider;
import com.tulskiy.keymaster.windows.KeyMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsProvider
extends Provider {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowsProvider.class);
    private static volatile int idSeq = 0;
    private volatile boolean listen = true;
    private volatile boolean reset = false;
    private final Object lock = new Object();
    private Thread thread;
    private int threadId;
    private final Map<Integer, HotKey> hotKeys = new HashMap<Integer, HotKey>();
    private final Queue<HotKey> registerQueue = new LinkedList<HotKey>();

    @Override
    public void init() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LOGGER.info("Starting Windows global hotkey provider");
                WinUser.MSG msg = new WinUser.MSG();
                Object object = WindowsProvider.this.lock;
                synchronized (object) {
                    WindowsProvider.this.threadId = Kernel32.INSTANCE.GetCurrentThreadId();
                    WindowsProvider.this.unblock();
                }
                while (WindowsProvider.this.listen || WindowsProvider.this.reset) {
                    if (WindowsProvider.this.listen) {
                        System.out.println("LISTEN");
                        int result = User32.INSTANCE.GetMessage(msg, null, 0, 0);
                        if (result == -1) {
                            LOGGER.warn("Error getting message: " + Kernel32.INSTANCE.GetLastError());
                            WindowsProvider.this.listen = false;
                        } else {
                            System.out.println("Recv: " + msg.message);
                            if (msg.message == 786) {
                                int id = msg.wParam.intValue();
                                HotKey hotKey = (HotKey)WindowsProvider.this.hotKeys.get(id);
                                if (hotKey != null) {
                                    WindowsProvider.this.fireEvent(hotKey);
                                }
                            }
                        }
                    }
                    object = WindowsProvider.this.lock;
                    synchronized (object) {
                        if (WindowsProvider.this.reset) {
                            LOGGER.info("Reset hotkeys");
                            for (Integer id : WindowsProvider.this.hotKeys.keySet()) {
                                User32.INSTANCE.UnregisterHotKey(null, id);
                            }
                            WindowsProvider.this.hotKeys.clear();
                            WindowsProvider.this.reset = false;
                        }
                        while (!WindowsProvider.this.registerQueue.isEmpty()) {
                            HotKey hotKey = (HotKey)WindowsProvider.this.registerQueue.poll();
                            if (hotKey.isUnregister()) {
                                WindowsProvider.this.unregister(hotKey);
                                continue;
                            }
                            WindowsProvider.this.register(hotKey);
                        }
                    }
                }
                LOGGER.info("Exit Windows global hotkey thread");
            }
        };
        this.thread = new Thread(runnable, "JKeyMaster-Windows");
        this.thread.start();
    }

    private void register(HotKey hotKey) {
        int id = idSeq++;
        int code = KeyMap.getCode(hotKey);
        if (User32.INSTANCE.RegisterHotKey(null, id, KeyMap.getModifiers(hotKey.keyStroke), code)) {
            LOGGER.info(String.format("Registered hotkey: %s (%2$d/0x%2$X) [%3$d]", hotKey, code, id));
            this.hotKeys.put(id, hotKey);
        } else {
            LOGGER.warn("Could not register hotkey: " + hotKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(KeyStroke keyCode, HotKeyListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.registerQueue.add(new HotKey(keyCode, listener));
            this.unblock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(MediaKey mediaKey, HotKeyListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.registerQueue.add(new HotKey(mediaKey, listener));
            this.unblock();
        }
    }

    private void unregister(HotKey hotKey) {
        this.hotKeys.entrySet().removeIf(regHotKey -> {
            boolean matches = hotKey.hasSameTrigger((HotKey)regHotKey.getValue());
            if (matches) {
                if (User32.INSTANCE.UnregisterHotKey(null, (Integer)regHotKey.getKey())) {
                    LOGGER.info("Unregistered hotkey: " + hotKey);
                } else {
                    LOGGER.warn("Could not unregister hotkey: " + hotKey);
                }
            }
            return matches;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(KeyStroke keyCode) {
        Object object = this.lock;
        synchronized (object) {
            this.registerQueue.add(new HotKey(keyCode, null));
            this.unblock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(MediaKey mediaKey) {
        Object object = this.lock;
        synchronized (object) {
            this.registerQueue.add(new HotKey(mediaKey, null));
            this.unblock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        if (this.isRunning()) {
            Object object = this.lock;
            synchronized (object) {
                this.reset = true;
                this.registerQueue.clear();
                this.unblock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.isRunning()) {
            Object object = this.lock;
            synchronized (object) {
                this.listen = false;
                this.unblock();
            }
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        super.stop();
    }

    @Override
    public boolean isRunning() {
        return this.thread != null && this.thread.isAlive();
    }

    private void unblock() {
        if (this.threadId != 0 && User32.INSTANCE.PostThreadMessage(this.threadId, 1025, null, null) == 0) {
            LOGGER.warn("Posting unblock message failed (thread " + this.threadId + "): " + Kernel32.INSTANCE.GetLastError());
        }
    }
}

