/*
 * Decompiled with CFR 0.152.
 */
package com.tulskiy.keymaster.x11;

import com.sun.jna.platform.unix.X11;
import com.sun.jna.ptr.IntByReference;
import com.tulskiy.keymaster.common.HotKey;
import com.tulskiy.keymaster.common.HotKeyListener;
import com.tulskiy.keymaster.common.MediaKey;
import com.tulskiy.keymaster.common.Provider;
import com.tulskiy.keymaster.x11.KeyMap;
import com.tulskiy.keymaster.x11.X11Ext;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X11Provider
extends Provider {
    private static final Logger LOGGER = LoggerFactory.getLogger(X11Provider.class);
    private X11.Display display;
    private X11.Window window;
    private volatile boolean listen = true;
    private Thread thread;
    private volatile boolean reset;
    private ErrorHandler errorHandler;
    private final Object lock = new Object();
    private Queue<X11HotKey> registerQueue = new LinkedList<X11HotKey>();
    private List<X11HotKey> hotKeys = new ArrayList<X11HotKey>();

    @Override
    public void init() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LOGGER.info("Starting X11 global hotkey provider");
                X11Provider.this.display = X11.INSTANCE.XOpenDisplay(null);
                X11Provider.this.errorHandler = new ErrorHandler();
                X11.INSTANCE.XSetErrorHandler(X11Provider.this.errorHandler);
                X11Provider.this.window = X11.INSTANCE.XDefaultRootWindow(X11Provider.this.display);
                X11.XEvent event = new X11.XEvent();
                IntByReference supported_rtrn = new IntByReference();
                X11Ext.Lib.XkbSetDetectableAutoRepeat(X11Provider.this.display, true, supported_rtrn);
                if (supported_rtrn.getValue() != 1) {
                    LOGGER.warn("auto repeat detection not supported");
                }
                while (X11Provider.this.listen || X11Provider.this.reset) {
                    if (X11Provider.this.listen) {
                        while (X11.INSTANCE.XPending(X11Provider.this.display) > 0) {
                            X11.INSTANCE.XNextEvent(X11Provider.this.display, event);
                            if (event.type != 2 && event.type != 3) continue;
                            this.processEvent(event);
                        }
                    }
                    Object object = X11Provider.this.lock;
                    synchronized (object) {
                        if (X11Provider.this.reset) {
                            LOGGER.info("Reset hotkeys");
                            X11Provider.this.resetAll();
                            X11Provider.this.reset = false;
                        }
                        while (!X11Provider.this.registerQueue.isEmpty()) {
                            X11HotKey hotKey = (X11HotKey)X11Provider.this.registerQueue.poll();
                            if (hotKey.isUnregister()) {
                                LOGGER.info("Unregistering hotkey: " + hotKey);
                                X11Provider.this.unregisterHotKey(hotKey);
                                X11Provider.this.hotKeys.removeIf(h -> h.hasSameTrigger(hotKey));
                                continue;
                            }
                            LOGGER.info("Registering hotkey: " + hotKey);
                            X11Provider.this.registerHotKey(hotKey);
                            X11Provider.this.hotKeys.add(hotKey);
                        }
                        try {
                            if (X11Provider.this.listen) {
                                X11Provider.this.lock.wait(300L);
                            }
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                LOGGER.info("Exit X11 global hotkey thread");
            }

            private void processEvent(X11.XEvent event) {
                X11.XKeyEvent xkey = (X11.XKeyEvent)event.readField("xkey");
                for (X11HotKey hotKey : X11Provider.this.hotKeys) {
                    int eventType;
                    int state = xkey.state & 0x4D;
                    int n = eventType = hotKey.keyStroke.isOnKeyRelease() ? 3 : 2;
                    if (hotKey.code != (byte)xkey.keycode || hotKey.modifiers != state || event.type != eventType) continue;
                    LOGGER.info("Received event for hotkey: " + hotKey);
                    X11Provider.this.fireEvent(hotKey);
                    break;
                }
            }
        };
        this.thread = new Thread(runnable, "JKeyMaster-X11");
        this.thread.start();
    }

    private void registerHotKey(X11HotKey hotKey) {
        if (hotKey.isMedia()) {
            this.registerMedia(hotKey);
        } else {
            this.register(hotKey);
        }
    }

    private void register(X11HotKey hotKey) {
        byte code = KeyMap.getCode(hotKey.keyStroke, this.display);
        if (code == 0) {
            LOGGER.warn("Could not find mapping for " + hotKey.keyStroke);
            return;
        }
        int modifiers = KeyMap.getModifiers(hotKey.keyStroke);
        hotKey.code = code;
        hotKey.modifiers = modifiers;
        for (int i = 0; i < 16; ++i) {
            int flags = this.correctModifiers(modifiers, i);
            X11.INSTANCE.XGrabKey(this.display, code, flags, this.window, 1, 1, 1);
        }
    }

    private void registerMedia(X11HotKey hotKey) {
        byte keyCode = KeyMap.getMediaCode(hotKey.mediaKey, this.display);
        hotKey.modifiers = 0;
        hotKey.code = keyCode;
        X11.INSTANCE.XGrabKey(this.display, keyCode, 0, this.window, 1, 1, 1);
    }

    private void unregisterHotKey(X11HotKey hotKey) {
        if (!hotKey.isMedia()) {
            int modifiers = hotKey.modifiers;
            for (int i = 0; i < 16; ++i) {
                int flags = this.correctModifiers(modifiers, i);
                X11.INSTANCE.XUngrabKey(this.display, hotKey.code, flags, this.window);
            }
        } else {
            X11.INSTANCE.XUngrabKey(this.display, hotKey.code, 0, this.window);
        }
    }

    private void resetAll() {
        for (X11HotKey hotKey : this.hotKeys) {
            this.unregisterHotKey(hotKey);
        }
        this.hotKeys.clear();
    }

    private int correctModifiers(int modifiers, int flags) {
        int ret = modifiers;
        if ((flags & 1) != 0) {
            ret |= 2;
        }
        if ((flags & 2) != 0) {
            ret |= 0x10;
        }
        if ((flags & 4) != 0) {
            ret |= 0x20;
        }
        if ((flags & 8) != 0) {
            ret |= 0x80;
        }
        return ret;
    }

    @Override
    public void stop() {
        if (this.isRunning()) {
            this.listen = false;
            try {
                this.thread.join();
                X11.INSTANCE.XCloseDisplay(this.display);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        super.stop();
    }

    @Override
    public boolean isRunning() {
        return this.thread != null && this.thread.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(KeyStroke keyCode, HotKeyListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.registerQueue.add(new X11HotKey(keyCode, listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(MediaKey mediaKey, HotKeyListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.registerQueue.add(new X11HotKey(mediaKey, listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(KeyStroke keyCode) {
        Object object = this.lock;
        synchronized (object) {
            this.registerQueue.add(new X11HotKey(keyCode, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(MediaKey mediaKey) {
        Object object = this.lock;
        synchronized (object) {
            this.registerQueue.add(new X11HotKey(mediaKey, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        if (this.isRunning()) {
            Object object = this.lock;
            synchronized (object) {
                this.reset = true;
                this.registerQueue.clear();
            }
        }
    }

    class X11HotKey
    extends HotKey {
        byte code;
        int modifiers;

        X11HotKey(KeyStroke keyStroke, HotKeyListener listener) {
            super(keyStroke, listener);
        }

        X11HotKey(MediaKey mediaKey, HotKeyListener listener) {
            super(mediaKey, listener);
        }
    }

    class ErrorHandler
    implements X11.XErrorHandler {
        ErrorHandler() {
        }

        @Override
        public int apply(X11.Display display, X11.XErrorEvent errorEvent) {
            byte[] buf = new byte[1024];
            X11.INSTANCE.XGetErrorText(display, errorEvent.error_code, buf, buf.length);
            int len = 0;
            while (buf[len] != 0) {
                ++len;
            }
            LOGGER.warn("Error: " + new String(buf, 0, len));
            return 0;
        }
    }
}

