/*
 * Decompiled with CFR 0.152.
 */
package webpdecoderjn;

import com.sun.jna.IntegerType;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;

public class WebPDecoder {
    private static final Logger LOGGER = Logger.getLogger(WebPDecoder.class.getName());
    private static final String LIB_NAME = "libwebp_animdecoder";
    private static boolean initialized = false;
    private static Path libPath = null;
    private static LibWebP libWebPInstance;
    private static final String JNA_TMPLIB_PREFIX = "jna";

    public static synchronized void init() throws IOException {
        WebPDecoder.init(false);
    }

    public static synchronized void init(boolean nextToJar) throws IOException {
        if (!initialized) {
            if (nextToJar) {
                libPath = WebPDecoder.findNextToJar();
            }
            if (libPath == null) {
                libPath = WebPDecoder.extractLib(LIB_NAME);
            }
            initialized = true;
        }
    }

    private static synchronized LibWebP lib() {
        if (libWebPInstance == null) {
            libWebPInstance = Native.load(libPath != null ? libPath.toString() : LIB_NAME, LibWebP.class);
            WebPDecoder.removeLibrary(libPath);
        }
        return libWebPInstance;
    }

    private static Path findNextToJar() {
        Path jarPath = WebPDecoder.getJarPath();
        if (jarPath == null) {
            if (WebPDecoder.debugEnabled()) {
                LOGGER.info("Find library next to JAR: path not found");
            }
            return null;
        }
        if (WebPDecoder.debugEnabled()) {
            LOGGER.info("Find library next to JAR: Checking " + jarPath);
        }
        String fileName = null;
        if (Platform.isWindows()) {
            fileName = "libwebp_animdecoder.dll";
        } else if (Platform.isLinux()) {
            fileName = "libwebp_animdecoder.so";
        } else if (Platform.isMac()) {
            fileName = "libwebp_animdecoder.dylib";
        }
        if (fileName != null) {
            Path libPath = jarPath.resolveSibling(fileName);
            if (Files.isRegularFile(libPath, new LinkOption[0])) {
                return libPath;
            }
            libPath = jarPath.resolveSibling("lib" + fileName);
            if (Files.isRegularFile(libPath, new LinkOption[0])) {
                return libPath;
            }
        }
        return null;
    }

    private static Path extractLib(String name) throws IOException {
        return Native.extractFromResourcePath(name).toPath();
    }

    private static void removeLibrary(Path path) {
        block5: {
            if (path == null) {
                return;
            }
            boolean isUnpacked = path.getFileName().toString().startsWith(JNA_TMPLIB_PREFIX);
            if (!isUnpacked || !Files.isRegularFile(path, new LinkOption[0])) {
                return;
            }
            if (path.toFile().delete()) {
                return;
            }
            try {
                Files.createFile(path.resolveSibling(path.getFileName() + ".x"), new FileAttribute[0]);
            }
            catch (IOException ex) {
                if (!WebPDecoder.debugEnabled()) break block5;
                LOGGER.warning("Couldn't create x file for " + path);
            }
        }
    }

    private static boolean debugEnabled() {
        return Objects.equals(System.getProperty("jna.debug_load"), "true");
    }

    public static boolean test() {
        try {
            WebPDecoder.testEx();
            return true;
        }
        catch (IOException | UnsatisfiedLinkError ex) {
            return false;
        }
    }

    public static void testEx() throws IOException, WebPDecoderException, UnsatisfiedLinkError {
        boolean expectedResult;
        URL url = WebPDecoder.class.getResource("/image/test.webp");
        WebPImage image = WebPDecoder.decode(WebPDecoder.getBytesFromURL(url));
        boolean bl = expectedResult = image.canvasWidth == 16 && image.canvasHeight == 16 && image.frameCount == 2 && image.frames.size() == 2 && image.loopCount == 1 && image.frames.get((int)0).delay == 480 && image.frames.get((int)1).delay == 1280;
        if (!expectedResult) {
            throw new WebPDecoderException("Unexpected decode result");
        }
    }

    public static WebPImage decodeUrl(String url) throws IOException, WebPDecoderException, UnsatisfiedLinkError {
        byte[] rawData = WebPDecoder.getBytesFromURL(new URL(url));
        return WebPDecoder.decode(rawData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebPImage decode(byte[] rawData) throws WebPDecoderException, UnsatisfiedLinkError {
        LibWebP.WebPAnimInfo info;
        ArrayList<WebPImageFrame> frames = new ArrayList<WebPImageFrame>();
        Pointer bytes = null;
        Pointer decoder = null;
        try {
            bytes = WebPDecoder.lib().WebPMalloc(rawData.length);
            bytes.write(0L, rawData, 0, rawData.length);
            LibWebP.WebPData data = new LibWebP.WebPData();
            data.bytes = bytes;
            data.length = new LibWebP.Size_T((long)rawData.length);
            decoder = WebPDecoder.lib().WebPAnimDecoderNewInternal(data, null, 263);
            if (decoder == null) {
                throw new WebPDecoderException("Failed creating decoder, invalid image?");
            }
            info = new LibWebP.WebPAnimInfo();
            if (WebPDecoder.lib().WebPAnimDecoderGetInfo(decoder, info) == 0) {
                throw new WebPDecoderException("Failed getting decoder info");
            }
            int prevTimestamp = 0;
            while (WebPDecoder.lib().WebPAnimDecoderHasMoreFrames(decoder) == 1) {
                PointerByReference buf = new PointerByReference();
                IntByReference timestamp = new IntByReference();
                if (WebPDecoder.lib().WebPAnimDecoderGetNext(decoder, buf, timestamp) == 0) {
                    throw new WebPDecoderException("Error decoding next frame");
                }
                int delay = timestamp.getValue() - prevTimestamp;
                prevTimestamp = timestamp.getValue();
                BufferedImage image = WebPDecoder.createImage(buf.getValue(), info.canvas_width, info.canvas_height);
                frames.add(new WebPImageFrame(image, timestamp.getValue(), delay));
            }
            if (decoder != null) {
                WebPDecoder.lib().WebPAnimDecoderDelete(decoder);
            }
            if (bytes != null) {
                WebPDecoder.lib().WebPFree(bytes);
            }
        }
        catch (Throwable throwable) {
            if (decoder != null) {
                WebPDecoder.lib().WebPAnimDecoderDelete(decoder);
            }
            if (bytes != null) {
                WebPDecoder.lib().WebPFree(bytes);
            }
            throw throwable;
        }
        return new WebPImage(frames, info.canvas_width, info.canvas_height, info.loop_count, Color.BLACK, info.frame_count);
    }

    private static BufferedImage createImage(Pointer pixelData, int width, int height) {
        if (pixelData != null) {
            int[] pixels = pixelData.getIntArray(0L, width * height);
            DirectColorModel colorModel = new DirectColorModel(32, 255, 65280, 0xFF0000, -16777216);
            SampleModel sampleModel = ((ColorModel)colorModel).createCompatibleSampleModel(width, height);
            DataBufferInt db = new DataBufferInt(pixels, width * height);
            WritableRaster raster = WritableRaster.createWritableRaster(sampleModel, db, null);
            return new BufferedImage(colorModel, raster, false, new Hashtable());
        }
        return null;
    }

    public static String getArch() {
        return Platform.ARCH;
    }

    public static byte[] getBytesFromURL(URL url) throws IOException {
        URLConnection c = url.openConnection();
        try (InputStream input = c.getInputStream();){
            byte[] imageData;
            byte[] byArray = imageData = WebPDecoder.readAllBytes(input);
            return byArray;
        }
    }

    private static byte[] readAllBytes(InputStream input) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = input.read(buffer, 0, buffer.length)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toByteArray();
    }

    public static Path getJarPath() {
        try {
            Path jarPath = Paths.get(WebPDecoder.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (!(jarPath.toString().endsWith(".jar") && Files.exists(jarPath, new LinkOption[0]) && Files.isRegularFile(jarPath, new LinkOption[0]))) {
                jarPath = null;
            }
            return jarPath;
        }
        catch (URISyntaxException ex) {
            LOGGER.warning("jar: " + ex);
            return null;
        }
    }

    private static interface LibWebP
    extends Library {
        public static final int WEBP_DEMUX_ABI_VERSION = 263;

        public Pointer WebPMalloc(int var1);

        public void WebPFree(Pointer var1);

        public Pointer WebPAnimDecoderNewInternal(WebPData var1, Structure var2, int var3);

        public int WebPAnimDecoderGetInfo(Pointer var1, WebPAnimInfo var2);

        public int WebPAnimDecoderHasMoreFrames(Pointer var1);

        public int WebPAnimDecoderGetNext(Pointer var1, PointerByReference var2, IntByReference var3);

        public void WebPAnimDecoderDelete(Pointer var1);

        public static class Size_T
        extends IntegerType {
            private static final long serialVersionUID = 1L;
            public static final Size_T ZERO = new Size_T();

            public Size_T() {
                this(0L);
            }

            public Size_T(long value) {
                super(Native.SIZE_T_SIZE, value, true);
            }
        }

        @Structure.FieldOrder(value={"canvas_width", "canvas_height", "loop_count", "bgcolor", "frame_count", "pad"})
        public static class WebPAnimInfo
        extends Structure {
            public int canvas_width;
            public int canvas_height;
            public int loop_count;
            public int bgcolor;
            public int frame_count;
            public int[] pad = new int[4];
        }

        @Structure.FieldOrder(value={"bytes", "length"})
        public static class WebPData
        extends Structure {
            public Pointer bytes;
            public Size_T length;
        }
    }

    public static class WebPImageFrame {
        public final BufferedImage img;
        public final int timestamp;
        public final int delay;

        private WebPImageFrame(BufferedImage img, int timestamp, int delay) {
            this.img = img;
            this.timestamp = timestamp;
            this.delay = delay;
        }

        public String toString() {
            return String.valueOf(this.delay);
        }
    }

    public static class WebPImage {
        public final List<WebPImageFrame> frames;
        public final int canvasWidth;
        public final int canvasHeight;
        public final int loopCount;
        public final Color bgColor;
        public final int frameCount;

        private WebPImage(List<WebPImageFrame> frames, int canvasWidth, int canvasHeight, int loopCount, Color bgColor, int frameCount) {
            this.frames = frames;
            this.canvasWidth = canvasWidth;
            this.canvasHeight = canvasHeight;
            this.frameCount = frameCount;
            this.loopCount = loopCount;
            this.bgColor = bgColor;
        }

        public String toString() {
            return String.format("%d x %d / %d loops / %d frames %s", this.canvasWidth, this.canvasHeight, this.loopCount, this.frameCount, this.frames);
        }
    }

    public static class WebPDecoderException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public WebPDecoderException(String message) {
            super(message);
        }
    }
}

